/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete;

import com.bstek.urule.ClassUtils;
import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.Line;
import com.bstek.urule.model.rete.NodeType;
import com.bstek.urule.runtime.rete.Activity;
import com.bstek.urule.runtime.rete.ObjectTypeActivity;
import java.util.Map;

public class ObjectTypeNode
extends BaseReteNode {
    public static final String NON_CLASS = "*";
    public static final String NONE_CONDITION = "__*__";
    private String objectTypeClass;
    private NodeType nodeType = NodeType.objectType;

    public ObjectTypeNode() {
        super(0);
    }

    public ObjectTypeNode(String string, int n) {
        super(n);
        this.objectTypeClass = string;
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    public boolean support(Object object) {
        return this.support(object.getClass().getName());
    }

    public boolean support(String string) {
        return this.objectTypeClass.equals(string);
    }

    public String getObjectTypeClass() {
        return this.objectTypeClass;
    }

    public void setObjectTypeClass(String string) {
        this.objectTypeClass = string;
    }

    @Override
    public Activity newActivity(Map<Object, Object> map) {
        Class<?> clazz = null;
        ObjectTypeActivity objectTypeActivity = null;
        if (this.objectTypeClass.equals(NONE_CONDITION)) {
            objectTypeActivity = new ObjectTypeActivity(this.objectTypeClass);
        } else {
            try {
                if (!this.objectTypeClass.equals(NON_CLASS)) {
                    clazz = ClassUtils.getTargetClassDefaultNull(this.objectTypeClass);
                }
                objectTypeActivity = clazz == null ? new ObjectTypeActivity(this.objectTypeClass) : new ObjectTypeActivity(clazz);
            }
            catch (Exception exception) {
                objectTypeActivity = new ObjectTypeActivity(this.objectTypeClass);
            }
        }
        for (Line line : this.lines) {
            objectTypeActivity.addPath(line.newPath(map));
        }
        return objectTypeActivity;
    }
}

