/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete;

import com.bstek.urule.model.Node;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.rete.MutexReteUnit;
import com.bstek.urule.model.rete.ObjectTypeNode;
import com.bstek.urule.model.rete.ReteUnit;
import com.bstek.urule.model.rete.RuleData;
import com.bstek.urule.runtime.rete.MutexReteInstanceUnit;
import com.bstek.urule.runtime.rete.ObjectTypeActivity;
import com.bstek.urule.runtime.rete.ReteInstance;
import com.bstek.urule.runtime.rete.ReteInstanceUnit;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Rete
implements Node {
    private List<ObjectTypeNode> objectTypeNodes;
    private Map<String, List<ReteUnit>> mutexGroupRetesMap;
    private Map<String, List<ReteUnit>> pendedGroupRetesMap;
    @JsonIgnore
    private List<RuleData> allRuleData;
    @JsonIgnore
    private ResourceLibrary resourceLibrary;

    public Rete() {
    }

    public Rete(List<ObjectTypeNode> list, ResourceLibrary resourceLibrary) {
        this.objectTypeNodes = list;
        this.resourceLibrary = resourceLibrary;
    }

    public List<ObjectTypeNode> getObjectTypeNodes() {
        return this.objectTypeNodes;
    }

    public ResourceLibrary getResourceLibrary() {
        return this.resourceLibrary;
    }

    public Map<String, List<ReteUnit>> getMutexGroupRetesMap() {
        return this.mutexGroupRetesMap;
    }

    public void setMutexGroupRetesMap(Map<String, List<ReteUnit>> map) {
        this.mutexGroupRetesMap = map;
    }

    public Map<String, List<ReteUnit>> getPendedGroupRetesMap() {
        return this.pendedGroupRetesMap;
    }

    public void setPendedGroupRetesMap(Map<String, List<ReteUnit>> map) {
        this.pendedGroupRetesMap = map;
    }

    public List<RuleData> getAllRuleData() {
        return this.allRuleData;
    }

    public void setAllRuleData(List<RuleData> list) {
        this.allRuleData = list;
    }

    public ReteInstance newReteInstance() {
        ArrayList<ObjectTypeActivity> arrayList = new ArrayList<ObjectTypeActivity>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (ObjectTypeNode object2 : this.objectTypeNodes) {
            arrayList.add((ObjectTypeActivity)object2.newActivity(hashMap));
        }
        Map<String, List<ReteInstanceUnit>> map = this.buildGroupRetesInstance(this.mutexGroupRetesMap);
        Map<String, List<ReteInstanceUnit>> map2 = this.buildGroupRetesInstance(this.pendedGroupRetesMap);
        return new ReteInstance(arrayList, map, map2, this.allRuleData);
    }

    private Map<String, List<ReteInstanceUnit>> buildGroupRetesInstance(Map<String, List<ReteUnit>> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, List<ReteInstanceUnit>> hashMap = new HashMap<String, List<ReteInstanceUnit>>();
        for (String string : map.keySet()) {
            List<ReteUnit> list = map.get(string);
            for (ReteUnit reteUnit : list) {
                Object object;
                Object object2;
                Object object3;
                Rete rete;
                ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    hashMap.put(string, arrayList);
                }
                if ((rete = reteUnit.getRete()) != null) {
                    object3 = rete.newReteInstance();
                    object2 = new ReteInstanceUnit((ReteInstance)object3, reteUnit.getRuleName());
                    ((ReteInstanceUnit)object2).setEffectiveDate(reteUnit.getEffectiveDate());
                    ((ReteInstanceUnit)object2).setExpiresDate(reteUnit.getExpiresDate());
                    arrayList.add(object2);
                    continue;
                }
                if (!(reteUnit instanceof MutexReteUnit)) continue;
                object3 = (MutexReteUnit)reteUnit;
                object2 = ((MutexReteUnit)object3).getList();
                ArrayList<ReteInstance> arrayList2 = new ArrayList<ReteInstance>();
                Object object4 = object2.iterator();
                while (object4.hasNext()) {
                    object = (ReteUnit)object4.next();
                    Rete rete2 = ((ReteUnit)object).getRete();
                    ReteInstance reteInstance = rete2.newReteInstance();
                    arrayList2.add(reteInstance);
                }
                object4 = ((MutexReteUnit)object3).getMutexGroupName();
                object = new MutexReteInstanceUnit((String)object4, arrayList2);
                ((ReteInstanceUnit)object).setEffectiveDate(reteUnit.getEffectiveDate());
                ((ReteInstanceUnit)object).setExpiresDate(reteUnit.getExpiresDate());
                arrayList.add(object);
            }
        }
        return hashMap;
    }
}

