/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete;

import com.bstek.urule.model.AbstractJsonDeserializer;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rete.AndNode;
import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.CriteriaNode;
import com.bstek.urule.model.rete.JsonUtils;
import com.bstek.urule.model.rete.Line;
import com.bstek.urule.model.rete.NodeType;
import com.bstek.urule.model.rete.ObjectTypeNode;
import com.bstek.urule.model.rete.OrNode;
import com.bstek.urule.model.rete.ReteNode;
import com.bstek.urule.model.rete.TerminalNode;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.lhs.AccumulateLeftPart;
import com.bstek.urule.model.rule.lhs.And;
import com.bstek.urule.model.rule.lhs.CalculateItem;
import com.bstek.urule.model.rule.lhs.CalculateType;
import com.bstek.urule.model.rule.lhs.CommonFunctionLeftPart;
import com.bstek.urule.model.rule.lhs.ConditionItem;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.FunctionLeftPart;
import com.bstek.urule.model.rule.lhs.Junction;
import com.bstek.urule.model.rule.lhs.Left;
import com.bstek.urule.model.rule.lhs.LeftPart;
import com.bstek.urule.model.rule.lhs.LeftType;
import com.bstek.urule.model.rule.lhs.MethodLeftPart;
import com.bstek.urule.model.rule.lhs.Or;
import com.bstek.urule.model.rule.lhs.VariableLeftPart;
import com.bstek.urule.model.rule.loop.LoopTarget;
import com.bstek.urule.model.rule.loop.LoopTargetType;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ReteNodeJsonDeserializer
extends AbstractJsonDeserializer<List<ReteNode>> {
    public List<ReteNode> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = jsonParser.getCodec();
        JsonNode jsonNode = (JsonNode)objectCodec.readTree(jsonParser);
        ArrayList<ReteNode> arrayList = new ArrayList<ReteNode>();
        Iterator iterator = jsonNode.elements();
        while (iterator.hasNext()) {
            ReteNode reteNode;
            JsonNode jsonNode2 = (JsonNode)iterator.next();
            int n = jsonNode2.get("id").intValue();
            JsonNode jsonNode3 = jsonNode2.get("nodeType");
            if (jsonNode3 == null) continue;
            String string = jsonNode3.textValue();
            NodeType nodeType = NodeType.valueOf(string);
            ReteNode reteNode2 = NodeType.newReteNodeInstance(nodeType);
            if (reteNode2 instanceof ObjectTypeNode) {
                reteNode = (ObjectTypeNode)reteNode2;
                ((ObjectTypeNode)reteNode).setObjectTypeClass(jsonNode2.get("objectTypeClass").textValue());
                reteNode.setId(n);
            } else if (reteNode2 instanceof AndNode) {
                reteNode = (AndNode)reteNode2;
                reteNode.setId(n);
                ((AndNode)reteNode).setToLineCount(jsonNode2.get("toLineCount").intValue());
                ((BaseReteNode)reteNode).setLines(this.parseLines(jsonNode2));
            } else if (reteNode2 instanceof OrNode) {
                reteNode = (OrNode)reteNode2;
                reteNode.setId(n);
                ((BaseReteNode)reteNode).setLines(this.parseLines(jsonNode2));
            } else if (reteNode2 instanceof CriteriaNode) {
                reteNode = (CriteriaNode)reteNode2;
                reteNode.setId(n);
                JsonNode jsonNode4 = jsonNode2.get("debug");
                if (jsonNode4 != null) {
                    ((CriteriaNode)reteNode).setDebug(jsonNode4.asBoolean());
                }
                JsonNode jsonNode5 = jsonNode2.get("criteria");
                ((CriteriaNode)reteNode).setCriteria(this.parseCriteria(jsonNode5));
                ((BaseReteNode)reteNode).setLines(this.parseLines(jsonNode2));
            } else if (reteNode2 instanceof TerminalNode) {
                reteNode = (TerminalNode)reteNode2;
                reteNode.setId(n);
                ((TerminalNode)reteNode).setRule(this.parseRule(jsonParser, jsonNode2));
            }
            arrayList.add(reteNode2);
        }
        return arrayList;
    }

    private List<Line> parseLines(JsonNode jsonNode) {
        JsonNode jsonNode2 = jsonNode.get("lines");
        if (jsonNode2 == null) {
            return null;
        }
        ArrayList<Line> arrayList = new ArrayList<Line>();
        for (JsonNode jsonNode3 : jsonNode2) {
            Line line = new Line();
            line.setFromNodeId(jsonNode3.get("fromNodeId").intValue());
            line.setToNodeId(jsonNode3.get("toNodeId").intValue());
            arrayList.add(line);
        }
        return arrayList;
    }

    private Criteria parseCriteria(JsonNode jsonNode) {
        Object object;
        String string;
        Object object2;
        Op op;
        String string2;
        Criteria criteria = new Criteria();
        JsonNode jsonNode2 = jsonNode.get("op");
        if (jsonNode2 != null && jsonNode2.textValue() != null) {
            string2 = jsonNode2.textValue();
            op = Op.valueOf(string2);
            criteria.setOp(op);
        }
        if (jsonNode.has("file") && jsonNode.get("file") != null) {
            string2 = jsonNode.get("file").textValue();
            criteria.setFile(string2);
        }
        if ((string2 = jsonNode.get("necessaryClassList")) != null && string2 instanceof ArrayNode) {
            op = (ArrayNode)string2;
            object2 = op.elements();
            while (object2.hasNext()) {
                string = ((JsonNode)object2.next()).asText();
                criteria.addNecessaryClass(string);
            }
        }
        op = jsonNode.get("left");
        object2 = new Left();
        criteria.setLeft((Left)object2);
        string = JsonUtils.getJsonValue((JsonNode)op, "type");
        JsonNode jsonNode3 = op.get("leftPart");
        ((Left)object2).setType(LeftType.valueOf(string));
        switch (((Left)object2).getType()) {
            case function: {
                object = new FunctionLeftPart();
                ((FunctionLeftPart)object).setName(JsonUtils.getJsonValue(jsonNode3, "name"));
                ((FunctionLeftPart)object).setParameters(JsonUtils.parseParameters(jsonNode3));
                ((Left)object2).setLeftPart((LeftPart)object);
                break;
            }
            case method: {
                MethodLeftPart methodLeftPart = new MethodLeftPart();
                methodLeftPart.setBeanId(JsonUtils.getJsonValue(jsonNode3, "beanId"));
                methodLeftPart.setBeanLabel(JsonUtils.getJsonValue(jsonNode3, "beanLabel"));
                methodLeftPart.setUuid(JsonUtils.getJsonValue(jsonNode3, "uuid"));
                methodLeftPart.setCategoryUuid(JsonUtils.getJsonValue(jsonNode3, "categoryUuid"));
                methodLeftPart.setMethodLabel(JsonUtils.getJsonValue(jsonNode3, "methodLabel"));
                methodLeftPart.setMethodName(JsonUtils.getJsonValue(jsonNode3, "methodName"));
                methodLeftPart.setParameters(JsonUtils.parseParameters(jsonNode3));
                ((Left)object2).setLeftPart(methodLeftPart);
                break;
            }
            case commonfunction: {
                CommonFunctionLeftPart commonFunctionLeftPart = new CommonFunctionLeftPart();
                commonFunctionLeftPart.setLabel(JsonUtils.getJsonValue(jsonNode3, "label"));
                commonFunctionLeftPart.setName(JsonUtils.getJsonValue(jsonNode3, "name"));
                commonFunctionLeftPart.setParameter(JsonUtils.parseCommonFunctionParameter(jsonNode3));
                ((Left)object2).setLeftPart(commonFunctionLeftPart);
                break;
            }
            case operatecollection: {
                Object object3;
                JsonNode jsonNode4;
                AccumulateLeftPart accumulateLeftPart = new AccumulateLeftPart();
                String string3 = JsonUtils.getJsonValue(jsonNode3, "loopTargetType");
                accumulateLeftPart.setLoopTargetType(LoopTargetType.valueOf(string3));
                accumulateLeftPart.setJunction(this.parseJunction(jsonNode3));
                JsonNode jsonNode5 = jsonNode3.get("loopTarget");
                LoopTarget loopTarget = new LoopTarget();
                loopTarget.setValue(JsonUtils.parseValue(jsonNode5));
                accumulateLeftPart.setLoopTarget(loopTarget);
                JsonNode jsonNode6 = jsonNode3.get("calculateItems");
                if (jsonNode6 != null) {
                    jsonNode4 = new ArrayList();
                    for (Iterator iterator : jsonNode6) {
                        CalculateItem calculateItem = new CalculateItem();
                        calculateItem.setType(CalculateType.valueOf(JsonUtils.getJsonValue((JsonNode)iterator, "type")));
                        object3 = JsonUtils.parseValue((JsonNode)iterator);
                        calculateItem.setValue((Value)object3);
                        boolean bl = Boolean.valueOf(JsonUtils.getJsonValue((JsonNode)iterator, "enableAssignment"));
                        calculateItem.setEnableAssignment(bl);
                        if (bl) {
                            calculateItem.setAssignDatatype(Datatype.valueOf(JsonUtils.getJsonValue((JsonNode)iterator, "assignDatatype")));
                            calculateItem.setAssignTargetType(JsonUtils.getJsonValue((JsonNode)iterator, "assignTargetType"));
                            calculateItem.setAssignCategoryUuid(JsonUtils.getJsonValue((JsonNode)iterator, "assignCategoryUuid"));
                            calculateItem.setAssignVariableUuid(JsonUtils.getJsonValue((JsonNode)iterator, "assignVariableUuid"));
                            calculateItem.setAssignVariable(JsonUtils.getJsonValue((JsonNode)iterator, "assignVariable"));
                            calculateItem.setAssignVariableCategory(JsonUtils.getJsonValue((JsonNode)iterator, "assignVariableCategory"));
                            calculateItem.setAssignVariableLabel(JsonUtils.getJsonValue((JsonNode)iterator, "assignVariableLabel"));
                            calculateItem.setKeyLabel(JsonUtils.getJsonValue((JsonNode)iterator, "keyLabel"));
                            calculateItem.setKeyName(JsonUtils.getJsonValue((JsonNode)iterator, "keyName"));
                            calculateItem.setType(CalculateType.valueOf(JsonUtils.getJsonValue((JsonNode)iterator, "type")));
                        }
                        jsonNode4.add(calculateItem);
                    }
                    accumulateLeftPart.setCalculateItems((List<CalculateItem>)jsonNode4);
                }
                if ((jsonNode4 = jsonNode3.get("conditionItems")) != null) {
                    ArrayList arrayList = new ArrayList();
                    for (CalculateItem calculateItem : jsonNode4) {
                        object3 = new ConditionItem();
                        ((ConditionItem)object3).setLeft(JsonUtils.getJsonValue((JsonNode)calculateItem, "left"));
                        ((ConditionItem)object3).setOp(Op.valueOf(JsonUtils.getJsonValue((JsonNode)calculateItem, "op")));
                        ((ConditionItem)object3).setValue(JsonUtils.parseValue((JsonNode)calculateItem));
                        arrayList.add(object3);
                    }
                    accumulateLeftPart.setConditionItems(arrayList);
                }
                ((Left)object2).setLeftPart(accumulateLeftPart);
                break;
            }
            default: {
                VariableLeftPart variableLeftPart = new VariableLeftPart();
                variableLeftPart.setVariableCategory(JsonUtils.getJsonValue(jsonNode3, "variableCategory"));
                variableLeftPart.setVariableLabel(JsonUtils.getJsonValue(jsonNode3, "variableLabel"));
                variableLeftPart.setVariableName(JsonUtils.getJsonValue(jsonNode3, "variableName"));
                variableLeftPart.setCategoryUuid(JsonUtils.getJsonValue(jsonNode3, "categoryUuid"));
                variableLeftPart.setUuid(JsonUtils.getJsonValue(jsonNode3, "uuid"));
                variableLeftPart.setKeyLabel(JsonUtils.getJsonValue(jsonNode3, "keyLabel"));
                variableLeftPart.setKeyName(JsonUtils.getJsonValue(jsonNode3, "keyName"));
                String string4 = JsonUtils.getJsonValue(jsonNode3, "datatype");
                if (StringUtils.isNotBlank((String)string4)) {
                    variableLeftPart.setDatatype(Datatype.valueOf(string4));
                }
                ((Left)object2).setLeftPart(variableLeftPart);
            }
        }
        ((Left)object2).setArithmetic(JsonUtils.parseComplexArithmetic((JsonNode)op));
        object = JsonUtils.parseValue(jsonNode);
        if (object != null) {
            criteria.setValue((Value)object);
        }
        return criteria;
    }

    private Junction parseJunction(JsonNode jsonNode) {
        JsonNode jsonNode2 = jsonNode.get("junction");
        if (jsonNode2 == null) {
            return null;
        }
        String string = JsonUtils.getJsonValue(jsonNode2, "junctionType");
        Junction junction = null;
        if (string.equals("and")) {
            junction = new And();
        } else if (string.equals("or")) {
            junction = new Or();
        }
        JsonNode jsonNode3 = jsonNode2.get("criterions");
        if (jsonNode3 != null) {
            Iterator iterator = jsonNode3.iterator();
            ArrayList<Criterion> arrayList = new ArrayList<Criterion>();
            while (iterator.hasNext()) {
                JsonNode jsonNode4 = (JsonNode)iterator.next();
                Criteria criteria = this.parseCriteria(jsonNode4);
                arrayList.add(criteria);
            }
            junction.setCriterions(arrayList);
        }
        return junction;
    }
}

