/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.lhs;

import com.bstek.urule.Utils;
import com.bstek.urule.model.rule.lhs.CalculateData;
import com.bstek.urule.model.rule.lhs.CalculateItem;
import com.bstek.urule.model.rule.lhs.ConditionItem;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.EvaluateResponse;
import com.bstek.urule.model.rule.lhs.Junction;
import com.bstek.urule.model.rule.lhs.LeftPart;
import com.bstek.urule.model.rule.lhs.Or;
import com.bstek.urule.model.rule.loop.LoopTarget;
import com.bstek.urule.model.rule.loop.LoopTargetType;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.EvaluationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class AccumulateLeftPart
implements LeftPart {
    private LoopTargetType loopTargetType;
    private LoopTarget loopTarget;
    private List<ConditionItem> conditionItems;
    private List<CalculateItem> calculateItems;
    private Junction junction;
    private String id;
    private static final Logger log = Logger.getLogger(AccumulateLeftPart.class.getName());

    public EvaluateResponse evaluate(EvaluationContext evaluationContext, Map<String, Object> map) {
        List<Object> list = this.buildLoopTarget(evaluationContext, map);
        if (list == null) {
            log.warning("AccumulateLeftPart collection value is null,return false.");
            EvaluateResponse evaluateResponse = new EvaluateResponse();
            evaluateResponse.setResult(false);
            return evaluateResponse;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(map);
        HashMap<String, CalculateData> hashMap2 = new HashMap<String, CalculateData>();
        boolean bl = false;
        for (Object iterator : list) {
            String string = Utils.getClassName(iterator);
            hashMap.put(string, iterator);
            boolean bl2 = this.evalCondition(evaluationContext, hashMap);
            if (!bl2) continue;
            bl = true;
            for (CalculateItem calculateItem : this.calculateItems) {
                calculateItem.calculate(evaluationContext, hashMap, iterator, hashMap2);
            }
        }
        if (!bl) {
            for (CalculateItem calculateItem : this.calculateItems) {
                calculateItem.init(hashMap2);
            }
        }
        for (CalculateData calculateData : hashMap2.values()) {
            calculateData.buildValue(evaluationContext, map);
        }
        Object object = null;
        for (ConditionItem conditionItem : this.conditionItems) {
            EvaluateResponse evaluateResponse = conditionItem.eval(hashMap2, evaluationContext, map);
            if (evaluateResponse.getResult()) continue;
            object = evaluateResponse;
            break;
        }
        if (object == null) {
            object = new EvaluateResponse();
            ((EvaluateResponse)object).setResult(true);
        }
        return object;
    }

    private boolean evalCondition(EvaluationContext evaluationContext, Map<String, Object> map) {
        if (this.junction == null) {
            return true;
        }
        List<Criterion> list = this.junction.getCriterions();
        if (list == null || list.size() == 0) {
            return true;
        }
        boolean bl = true;
        if (this.junction instanceof Or) {
            bl = false;
        }
        boolean bl2 = false;
        for (Criterion criterion : list) {
            Criteria criteria = (Criteria)criterion;
            EvaluateResponse evaluateResponse = criteria.evaluate(evaluationContext, map);
            if (bl) {
                if (!evaluateResponse.getResult()) {
                    bl2 = false;
                    break;
                }
                bl2 = true;
                continue;
            }
            if (evaluateResponse.getResult()) {
                bl2 = true;
                break;
            }
            bl2 = false;
        }
        return bl2;
    }

    private List<Object> buildLoopTarget(Context context, Map<String, Object> map) {
        Object object = context.getValueCompute().complexValueCompute(this.loopTarget.getValue(), context, map);
        if (this.loopTargetType.equals((Object)LoopTargetType.list)) {
            if (object instanceof Collection) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Collection collection = (Collection)object;
                arrayList.addAll(collection);
                return arrayList;
            }
            return null;
        }
        KnowledgeSession knowledgeSession = (KnowledgeSession)context.getWorkingMemory();
        List<Object> list = knowledgeSession.getFactList();
        String string = Utils.getClassName(object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object2 : list) {
            String string2 = Utils.getClassName(object2);
            if (!string2.equals(string)) continue;
            arrayList.add(object2);
        }
        return arrayList;
    }

    public LoopTargetType getLoopTargetType() {
        return this.loopTargetType;
    }

    public void setLoopTargetType(LoopTargetType loopTargetType) {
        this.loopTargetType = loopTargetType;
    }

    public LoopTarget getLoopTarget() {
        return this.loopTarget;
    }

    public void setLoopTarget(LoopTarget loopTarget) {
        this.loopTarget = loopTarget;
    }

    public List<ConditionItem> getConditionItems() {
        return this.conditionItems;
    }

    public void setConditionItems(List<ConditionItem> list) {
        this.conditionItems = list;
    }

    public List<CalculateItem> getCalculateItems() {
        return this.calculateItems;
    }

    public void setCalculateItems(List<CalculateItem> list) {
        this.calculateItems = list;
    }

    public Junction getJunction() {
        return this.junction;
    }

    public void setJunction(Junction junction) {
        this.junction = junction;
    }

    @Override
    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        this.id = "\u805a\u5408," + this.loopTargetType.toString() + ":" + this.loopTarget.getValue().getId();
        int n = 0;
        for (ConditionItem iterator : this.conditionItems) {
            this.id = n == 0 ? this.id + "\uff1b\u6761\u4ef6:" : this.id + ",";
            this.id = this.id + iterator.getLeft() + (Object)((Object)iterator.getOp()) + iterator.getValue().getId();
            ++n;
        }
        n = 0;
        for (CalculateItem calculateItem : this.calculateItems) {
            this.id = n == 0 ? this.id + ";\u8ba1\u7b97:" : this.id + ",";
            this.id = this.id + (Object)((Object)calculateItem.getType());
            if (calculateItem.getValue() != null) {
                this.id = this.id + "(" + calculateItem.getValue().getId() + ")";
            }
            if (!calculateItem.isEnableAssignment()) continue;
            this.id = this.id + "\u8d4b\u7ed9" + calculateItem.getAssignTargetType() + ":" + calculateItem.getAssignVariableCategory() + "." + calculateItem.getAssignVariableLabel();
            if (calculateItem.getKeyLabel() == null) continue;
            this.id = this.id + "." + calculateItem.getKeyLabel();
        }
        if (this.junction != null && this.junction.getCriterions() != null) {
            List<Criterion> list = this.junction.getCriterions();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Criterion criterion = (Criterion)iterator.next();
                if (!(criterion instanceof Criteria)) continue;
                Criteria criteria = (Criteria)criterion;
                this.id = this.id + criteria.getId();
            }
        }
        return this.id;
    }
}

