/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.lhs;

import com.bstek.urule.action.VariableAssignAction;
import com.bstek.urule.model.rule.ObjectValue;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.lhs.CalculateItem;
import com.bstek.urule.runtime.rete.EvaluationContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CalculateData {
    private CalculateItem item;
    private int count = 1;
    private BigDecimal value;
    private Object resultValue;
    private boolean doAssignment;
    private List<Object> collectObjects = new ArrayList<Object>();

    public CalculateData(CalculateItem calculateItem) {
        this.item = calculateItem;
    }

    public Object getResultValue() {
        return this.resultValue;
    }

    public void buildValue(EvaluationContext evaluationContext, Map<String, Object> map) {
        Object object;
        BigDecimal bigDecimal = BigDecimal.valueOf(this.count);
        switch (this.item.getType()) {
            case count: {
                this.resultValue = bigDecimal;
                break;
            }
            case avg: {
                if (this.value != null) {
                    this.resultValue = object = this.value.divide(bigDecimal, 8, 4).stripTrailingZeros();
                    break;
                }
                this.resultValue = null;
                break;
            }
            case max: {
                this.resultValue = this.value;
                break;
            }
            case min: {
                this.resultValue = this.value;
                break;
            }
            case sum: {
                this.resultValue = this.value;
                break;
            }
            case collect: {
                this.resultValue = this.collectObjects;
            }
        }
        if (this.item.isEnableAssignment() && !this.doAssignment) {
            object = new ObjectValue(this.resultValue);
            this.doAssignment((Value)object, evaluationContext, map);
            this.doAssignment = true;
        }
    }

    private void doAssignment(Value value, EvaluationContext evaluationContext, Map<String, Object> map) {
        VariableAssignAction variableAssignAction = new VariableAssignAction();
        variableAssignAction.setValue(value);
        variableAssignAction.setDatatype(this.item.getAssignDatatype());
        variableAssignAction.setVariableName(this.item.getAssignVariable());
        variableAssignAction.setVariableLabel(this.item.getAssignVariableLabel());
        variableAssignAction.setVariableCategory(this.item.getAssignVariableCategory());
        variableAssignAction.setKeyLabel(this.item.getKeyLabel());
        variableAssignAction.setKeyName(this.item.getKeyName());
        variableAssignAction.execute(evaluationContext, map);
    }

    public void addObject(Object object) {
        this.collectObjects.add(object);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }
}

