/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.lhs;

import com.bstek.urule.Utils;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.lhs.CalculateData;
import com.bstek.urule.model.rule.lhs.CalculateType;
import com.bstek.urule.runtime.rete.EvaluationContext;
import java.math.BigDecimal;
import java.util.Map;

public class CalculateItem {
    private CalculateType type;
    private Value value;
    private boolean enableAssignment;
    private String assignTargetType;
    private String assignCategoryUuid;
    private String assignVariableCategory;
    private String assignVariable;
    private String assignVariableUuid;
    private String assignVariableLabel;
    private Datatype assignDatatype;
    private String keyLabel;
    private String keyName;

    public void init(Map<String, CalculateData> map) {
        CalculateData calculateData = new CalculateData(this);
        calculateData.setCount(0);
        calculateData.setValue(new BigDecimal(0));
        map.put(this.type.name(), calculateData);
    }

    public void calculate(EvaluationContext evaluationContext, Map<String, Object> map, Object object, Map<String, CalculateData> map2) {
        switch (this.type) {
            case count: {
                CalculateData calculateData = map2.get(this.type.toString());
                if (calculateData == null) {
                    calculateData = new CalculateData(this);
                    map2.put(this.type.name(), calculateData);
                    break;
                }
                calculateData.setCount(calculateData.getCount() + 1);
                break;
            }
            case avg: {
                this.doCal(evaluationContext, map, map2);
                break;
            }
            case max: {
                this.doCal(evaluationContext, map, map2);
                break;
            }
            case min: {
                this.doCal(evaluationContext, map, map2);
                break;
            }
            case sum: {
                this.doCal(evaluationContext, map, map2);
                break;
            }
            case collect: {
                CalculateData calculateData = map2.get(this.type.toString());
                if (calculateData == null) {
                    calculateData = new CalculateData(this);
                    calculateData.addObject(object);
                    map2.put(this.type.name(), calculateData);
                    break;
                }
                calculateData.addObject(object);
            }
        }
    }

    private void doCal(EvaluationContext evaluationContext, Map<String, Object> map, Map<String, CalculateData> map2) {
        CalculateData calculateData;
        Object object = evaluationContext.getValueCompute().complexValueCompute(this.value, evaluationContext, map);
        BigDecimal bigDecimal = null;
        if (object != null) {
            bigDecimal = Utils.toBigDecimal(object);
        }
        if ((calculateData = map2.get(this.type.name())) == null) {
            calculateData = new CalculateData(this);
            calculateData.setValue(bigDecimal);
            map2.put(this.type.name(), calculateData);
        } else {
            calculateData.setCount(calculateData.getCount() + 1);
            if (bigDecimal != null) {
                BigDecimal bigDecimal2 = calculateData.getValue();
                if (bigDecimal2 != null) {
                    if (this.type.equals((Object)CalculateType.max)) {
                        int n = bigDecimal.compareTo(bigDecimal2);
                        if (n == 1) {
                            calculateData.setValue(bigDecimal);
                        }
                    } else if (this.type.equals((Object)CalculateType.min)) {
                        int n = bigDecimal.compareTo(bigDecimal2);
                        if (n == 0) {
                            calculateData.setValue(bigDecimal);
                        }
                    } else {
                        BigDecimal bigDecimal3 = Utils.toBigDecimal(bigDecimal2);
                        calculateData.setValue(bigDecimal.add(bigDecimal3));
                    }
                } else {
                    calculateData.setValue(bigDecimal);
                }
            }
        }
    }

    public CalculateType getType() {
        return this.type;
    }

    public void setType(CalculateType calculateType) {
        this.type = calculateType;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public boolean isEnableAssignment() {
        return this.enableAssignment;
    }

    public void setEnableAssignment(boolean bl) {
        this.enableAssignment = bl;
    }

    public String getAssignTargetType() {
        return this.assignTargetType;
    }

    public void setAssignTargetType(String string) {
        this.assignTargetType = string;
    }

    public String getAssignVariableCategory() {
        return this.assignVariableCategory;
    }

    public void setAssignVariableCategory(String string) {
        this.assignVariableCategory = string;
    }

    public String getAssignVariable() {
        return this.assignVariable;
    }

    public void setAssignVariable(String string) {
        this.assignVariable = string;
    }

    public String getAssignVariableLabel() {
        return this.assignVariableLabel;
    }

    public void setAssignVariableLabel(String string) {
        this.assignVariableLabel = string;
    }

    public String getAssignCategoryUuid() {
        return this.assignCategoryUuid;
    }

    public void setAssignCategoryUuid(String string) {
        this.assignCategoryUuid = string;
    }

    public String getAssignVariableUuid() {
        return this.assignVariableUuid;
    }

    public void setAssignVariableUuid(String string) {
        this.assignVariableUuid = string;
    }

    public Datatype getAssignDatatype() {
        return this.assignDatatype;
    }

    public void setAssignDatatype(Datatype datatype) {
        this.assignDatatype = datatype;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public void setKeyLabel(String string) {
        this.keyLabel = string;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String string) {
        this.keyName = string;
    }
}

