/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.loop;

import com.bstek.urule.action.Action;
import com.bstek.urule.model.GeneralEntity;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.loop.LoopEnd;
import com.bstek.urule.model.rule.loop.LoopRuleUnit;
import com.bstek.urule.model.rule.loop.LoopStart;
import com.bstek.urule.model.rule.loop.LoopTarget;
import com.bstek.urule.model.rule.loop.LoopTargetType;
import com.bstek.urule.runtime.FactManager;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.KnowledgeSessionFactory;
import com.bstek.urule.runtime.rete.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class LoopRule
extends Rule {
    private LoopStart loopStart;
    private LoopEnd loopEnd;
    private LoopTargetType loopTargetType = LoopTargetType.list;
    private LoopTarget loopTarget;
    private List<LoopRuleUnit> units;
    private KnowledgePackageWrapper knowledgePackageWrapper;
    private Logger log = Logger.getGlobal();

    public LoopRule() {
        this.setLoopRule(true);
    }

    public void execute(Context context, Map<String, Object> map) {
        Object object = this.buildLoopTarget(context, map);
        if (object == null) {
            this.log.warning("Loop rule [" + this.getName() + "] target value is null,cannot be executed.");
            return;
        }
        KnowledgeSession knowledgeSession = (KnowledgeSession)context.getWorkingMemory();
        Map<String, Object> map2 = knowledgeSession.getParameters();
        if (this.loopStart != null) {
            this.doActions(this.loopStart.getActions(), context, map, true);
        }
        boolean bl = true;
        KnowledgeSession knowledgeSession2 = KnowledgeSessionFactory.newKnowledgeSession(this.knowledgePackageWrapper, context, knowledgeSession);
        List<Object> list = knowledgeSession.getFactList();
        if (object instanceof Collection) {
            Object e;
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext() && !this.breakLoop(map2 = this.doLoop(knowledgeSession2, map2, e = iterator.next(), list, bl))) {
                bl = false;
            }
        } else if (object instanceof Object[]) {
            Object object2;
            Object[] objectArray;
            Object[] objectArray2 = objectArray = (Object[])object;
            int n = objectArray2.length;
            for (int i = 0; i < n && !this.breakLoop(map2 = this.doLoop(knowledgeSession2, map2, object2 = objectArray2[i], list, bl)); ++i) {
                bl = false;
            }
        }
        knowledgeSession.getParameters().putAll(map2);
        if (this.loopEnd != null) {
            this.doActions(this.loopEnd.getActions(), context, map, false);
        }
    }

    private Map<String, Object> doLoop(KnowledgeSession knowledgeSession, Map<String, Object> map, Object object, List<Object> list, boolean bl) {
        FactManager factManager = knowledgeSession.getFactManager();
        String string = this.getClass(object);
        if (bl) {
            factManager.clean();
        }
        for (Object object2 : list) {
            String string2 = this.getClass(object2);
            if (string2.equals(HashMap.class.getName()) || string2.equals(string)) continue;
            factManager.insertLoopFact(object2);
        }
        factManager.insertLoopFact(object);
        knowledgeSession.fireRules(map);
        Map<String, Object> map2 = knowledgeSession.getParameters();
        map = new HashMap<String, Object>();
        map.putAll(map2);
        return map;
    }

    private boolean breakLoop(Map<String, Object> map) {
        boolean bl = false;
        if (map.containsKey("_loop_rule_break_tag__")) {
            map.remove("_loop_rule_break_tag__");
            bl = true;
        }
        return bl;
    }

    private void doActions(List<Action> list, Context context, Map<String, Object> map, boolean bl) {
        if (list == null || list.size() == 0) {
            return;
        }
        if (bl) {
            context.addTipMsg("\u6267\u884c\u3010" + this.getName() + "\u3011\u5f00\u59cb\u524d\u52a8\u4f5c");
            context.getLogger().logMessage("==\u6267\u884c\u5faa\u73af\u89c4\u5219\u89c4\u5219\u3010" + this.getName() + "\u3011\u7684\u5f00\u59cb\u524d\u52a8\u4f5c==");
        } else {
            context.addTipMsg("\u6267\u884c\u3010" + this.getName() + "\u3011\u7ed3\u675f\u540e\u52a8\u4f5c");
            context.getLogger().logMessage("==\u6267\u884c\u5faa\u73af\u89c4\u5219\u89c4\u5219\u3010" + this.getName() + "\u3011\u7684\u7ed3\u675f\u540e\u52a8\u4f5c==");
        }
        for (Action action : list) {
            if (this.getDebug() != null) {
                action.setDebug(this.getDebug());
            }
            action.execute(context, map);
        }
        context.cleanTipMsg();
    }

    private Object buildLoopTarget(Context context, Map<String, Object> map) {
        Object object = context.getValueCompute().complexValueCompute(this.loopTarget.getValue(), context, map);
        if (this.loopTargetType.equals((Object)LoopTargetType.list)) {
            if (object != null && !(object instanceof Collection) && !(object instanceof Object[])) {
                throw new RuntimeException("\u5faa\u73af\u5bf9\u8c61\u5fc5\u987b\u662f\u4e00\u4e2aCollection\u7c7b\u578b\u7684\u96c6\u5408\u5bf9\u8c61\u6216\u4e00\u4e2a\u6570\u7ec4\u5bf9\u8c61\uff0c\u5f53\u524d\u5bf9\u8c61\u4e3a\uff1a" + object + ".");
            }
            return object;
        }
        KnowledgeSession knowledgeSession = (KnowledgeSession)context.getWorkingMemory();
        List<Object> list = knowledgeSession.getFactList();
        String string = this.getClass(object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object2 : list) {
            String string2 = this.getClass(object2);
            if (!string2.equals(string)) continue;
            arrayList.add(object2);
        }
        return arrayList;
    }

    private String getClass(Object object) {
        String string = null;
        string = object instanceof GeneralEntity ? ((GeneralEntity)object).getTargetClass() : object.getClass().getName();
        return string;
    }

    public List<LoopRuleUnit> getUnits() {
        return this.units;
    }

    public void setUnits(List<LoopRuleUnit> list) {
        this.units = list;
    }

    public LoopStart getLoopStart() {
        return this.loopStart;
    }

    public void setLoopStart(LoopStart loopStart) {
        this.loopStart = loopStart;
    }

    public LoopEnd getLoopEnd() {
        return this.loopEnd;
    }

    public void setLoopEnd(LoopEnd loopEnd) {
        this.loopEnd = loopEnd;
    }

    public LoopTargetType getLoopTargetType() {
        return this.loopTargetType;
    }

    public void setLoopTargetType(LoopTargetType loopTargetType) {
        this.loopTargetType = loopTargetType;
    }

    public LoopTarget getLoopTarget() {
        return this.loopTarget;
    }

    public void setLoopTarget(LoopTarget loopTarget) {
        this.loopTarget = loopTarget;
    }

    public KnowledgePackageWrapper getKnowledgePackageWrapper() {
        return this.knowledgePackageWrapper;
    }

    public void setKnowledgePackageWrapper(KnowledgePackageWrapper knowledgePackageWrapper) {
        this.knowledgePackageWrapper = knowledgePackageWrapper;
    }
}

