/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.math;

import com.bstek.urule.Utils;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.math.MathSign;
import com.bstek.urule.model.rule.math.MathType;
import com.bstek.urule.runtime.rete.Context;
import java.math.BigDecimal;
import java.util.Map;

public class AbsoluteMath
implements MathSign {
    private Value value;

    @Override
    public Object calculate(Context context, Map<String, Object> map) {
        Object object = context.getValueCompute().complexValueCompute(this.value, context, map);
        if (object instanceof Integer) {
            int n = (Integer)object;
            return Math.abs(n);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            return Math.abs(d);
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            return Float.valueOf(Math.abs(f));
        }
        if (object instanceof Long) {
            long l = (Long)object;
            return Math.abs(l);
        }
        BigDecimal bigDecimal = Utils.toBigDecimal(object);
        return new BigDecimal(Math.abs(bigDecimal.doubleValue())).stripTrailingZeros();
    }

    @Override
    public MathType getType() {
        return MathType.absolute;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    @Override
    public String getId() {
        return "[\u6c42\u7edd\u5bf9\u503c]|" + this.value.getId() + "|";
    }
}

