/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.math;

import com.bstek.urule.Utils;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.math.MathSign;
import com.bstek.urule.model.rule.math.MathType;
import com.bstek.urule.runtime.rete.Context;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

public class FractionMath
implements MathSign {
    private Value numerator;
    private Value denominator;

    @Override
    public Object calculate(Context context, Map<String, Object> map) {
        Object object = context.getValueCompute().complexValueCompute(this.numerator, context, map);
        Object object2 = context.getValueCompute().complexValueCompute(this.denominator, context, map);
        BigDecimal bigDecimal = Utils.toBigDecimal(object);
        BigDecimal bigDecimal2 = Utils.toBigDecimal(object2);
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, 15, RoundingMode.HALF_UP).stripTrailingZeros();
        return bigDecimal3.stripTrailingZeros();
    }

    public Value getNumerator() {
        return this.numerator;
    }

    public void setNumerator(Value value) {
        this.numerator = value;
    }

    public Value getDenominator() {
        return this.denominator;
    }

    public void setDenominator(Value value) {
        this.denominator = value;
    }

    @Override
    public MathType getType() {
        return MathType.fraction;
    }

    @Override
    public String getId() {
        return "[\u5206\u6570]" + this.numerator.getId() + "/" + this.denominator.getId();
    }
}

