/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.math;

import com.bstek.urule.Utils;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.math.MathSign;
import com.bstek.urule.model.rule.math.MathType;
import com.bstek.urule.runtime.rete.Context;
import java.math.BigDecimal;
import java.util.Map;

public class LogMath
implements MathSign {
    private Value baseValue;
    private Value value;

    @Override
    public Object calculate(Context context, Map<String, Object> map) {
        Object object = context.getValueCompute().complexValueCompute(this.value, context, map);
        Object object2 = context.getValueCompute().complexValueCompute(this.baseValue, context, map);
        double d = Utils.toBigDecimal(object).doubleValue();
        double d2 = Utils.toBigDecimal(object2).doubleValue();
        return new BigDecimal(Math.log(d) / Math.log(d2)).stripTrailingZeros();
    }

    @Override
    public String getId() {
        return "[\u5bf9\u6570]" + this.baseValue + "," + this.value + "";
    }

    public Value getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(Value value) {
        this.baseValue = value;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    @Override
    public MathType getType() {
        return MathType.log;
    }
}

