/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.math;

import com.bstek.urule.Utils;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.math.MathSign;
import com.bstek.urule.model.rule.math.MathType;
import com.bstek.urule.runtime.rete.Context;
import java.math.BigDecimal;
import java.util.Map;

public class RadicalMath
implements MathSign {
    private Value value;

    @Override
    public Object calculate(Context context, Map<String, Object> map) {
        Object object = context.getValueCompute().complexValueCompute(this.value, context, map);
        BigDecimal bigDecimal = Utils.toBigDecimal(object);
        return new BigDecimal(Math.sqrt(bigDecimal.doubleValue())).stripTrailingZeros();
    }

    @Override
    public MathType getType() {
        return MathType.radical;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    @Override
    public String getId() {
        return "[\u5e73\u65b9\u6839]\u221a" + this.value.getId();
    }
}

