/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rule.math;

import com.bstek.urule.Utils;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.math.MathSign;
import com.bstek.urule.model.rule.math.MathType;
import com.bstek.urule.runtime.rete.Context;
import java.math.BigDecimal;
import java.util.Map;

public class TriangleFunctionMath
implements MathSign {
    private String name;
    private Value value;

    @Override
    public Object calculate(Context context, Map<String, Object> map) {
        Object object = context.getValueCompute().complexValueCompute(this.value, context, map);
        if (this.name.equals("sin")) {
            double d = Math.sin(Utils.toBigDecimal(object).doubleValue());
            return new BigDecimal(d).stripTrailingZeros();
        }
        if (this.name.equals("cos")) {
            double d = Math.cos(Utils.toBigDecimal(object).doubleValue());
            return new BigDecimal(d).stripTrailingZeros();
        }
        if (this.name.equals("tan")) {
            double d = Math.tan(Utils.toBigDecimal(object).doubleValue());
            return new BigDecimal(d).stripTrailingZeros();
        }
        if (this.name.equals("cot")) {
            double d = 1.0 / Math.tan(Utils.toBigDecimal(object).doubleValue());
            return new BigDecimal(d).stripTrailingZeros();
        }
        if (this.name.equals("sec")) {
            double d = 1.0 / Math.cos(Utils.toBigDecimal(object).doubleValue());
            return new BigDecimal(d).stripTrailingZeros();
        }
        if (this.name.equals("csc")) {
            double d = 1.0 / Math.sin(Utils.toBigDecimal(object).doubleValue());
            return new BigDecimal(d).stripTrailingZeros();
        }
        if (this.name.equals("arcsin")) {
            double d = Math.asin(Utils.toBigDecimal(object).doubleValue());
            return new BigDecimal(d).stripTrailingZeros();
        }
        if (this.name.equals("arccos")) {
            double d = Math.acos(Utils.toBigDecimal(object).doubleValue());
            return new BigDecimal(d).stripTrailingZeros();
        }
        if (this.name.equals("arctan")) {
            double d = Math.atan(Utils.toBigDecimal(object).doubleValue());
            return new BigDecimal(d).stripTrailingZeros();
        }
        if (this.name.equals("arccot")) {
            double d = Math.atan(1.0 / Utils.toBigDecimal(object).doubleValue());
            return new BigDecimal(d).stripTrailingZeros();
        }
        if (this.name.equals("arcsec")) {
            double d = Math.acos(1.0 / Utils.toBigDecimal(object).doubleValue());
            return new BigDecimal(d).stripTrailingZeros();
        }
        if (this.name.equals("arccsc")) {
            double d = Math.asin(1.0 / Utils.toBigDecimal(object).doubleValue());
            return new BigDecimal(d).stripTrailingZeros();
        }
        throw new RuleException("Unknow triangle function name :" + this.name + "");
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getId() {
        return "[\u4e09\u89d2\u51fd\u6570(" + this.name + ")](" + this.value.getId() + ")";
    }

    @Override
    public MathType getType() {
        return MathType.triangle;
    }
}

