/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.scorecard.runtime;

import com.bstek.urule.Utils;
import com.bstek.urule.model.scorecard.runtime.RowItem;
import com.bstek.urule.model.scorecard.runtime.Scorecard;
import com.bstek.urule.runtime.rete.Context;
import java.math.BigDecimal;
import java.util.List;

public class ScorecardImpl
implements Scorecard {
    private String name;
    private boolean debug;
    private List<RowItem> rowItems;

    public ScorecardImpl(String string, List<RowItem> list, boolean bl) {
        this.name = string;
        this.rowItems = list;
        this.debug = bl;
    }

    public BigDecimal executeSum(Context context) {
        BigDecimal bigDecimal = null;
        for (RowItem rowItem : this.rowItems) {
            BigDecimal bigDecimal2 = Utils.toBigDecimal(rowItem.getScore());
            rowItem.setActualScore(bigDecimal2);
            if (bigDecimal == null) {
                bigDecimal = bigDecimal2;
                continue;
            }
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        if (this.debug) {
            context.getLogger().logScoreCardSum(this.name, bigDecimal);
        }
        if (bigDecimal == null) {
            return new BigDecimal(0);
        }
        return bigDecimal;
    }

    public BigDecimal executeWeightSum(Context context) {
        BigDecimal bigDecimal = new BigDecimal(0);
        for (RowItem rowItem : this.rowItems) {
            BigDecimal bigDecimal2 = Utils.toBigDecimal(rowItem.getScore());
            BigDecimal bigDecimal3 = Utils.toBigDecimal(rowItem.getWeight());
            BigDecimal bigDecimal4 = bigDecimal2.multiply(bigDecimal3);
            rowItem.setActualScore(bigDecimal4);
            bigDecimal = bigDecimal.add(bigDecimal4);
        }
        if (this.debug) {
            context.getLogger().logScoreCardSum(this.name, bigDecimal);
        }
        return bigDecimal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<RowItem> getRowItems() {
        return this.rowItems;
    }
}

