/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse;

import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.ComplexArithmetic;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.model.rule.SimpleArithmetic;
import com.bstek.urule.model.rule.SimpleArithmeticValue;
import com.bstek.urule.model.rule.SimpleValue;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.lhs.AccumulateLeftPart;
import com.bstek.urule.model.rule.lhs.CalculateItem;
import com.bstek.urule.model.rule.lhs.CalculateType;
import com.bstek.urule.model.rule.lhs.CommonFunctionLeftPart;
import com.bstek.urule.model.rule.lhs.CommonFunctionParameter;
import com.bstek.urule.model.rule.lhs.ConditionItem;
import com.bstek.urule.model.rule.lhs.FunctionLeftPart;
import com.bstek.urule.model.rule.lhs.Junction;
import com.bstek.urule.model.rule.lhs.Left;
import com.bstek.urule.model.rule.lhs.LeftType;
import com.bstek.urule.model.rule.lhs.MethodLeftPart;
import com.bstek.urule.model.rule.lhs.VariableLeftPart;
import com.bstek.urule.model.rule.loop.LoopTarget;
import com.bstek.urule.model.rule.loop.LoopTargetType;
import com.bstek.urule.parse.AbstractParser;
import com.bstek.urule.parse.ComplexArithmeticParser;
import com.bstek.urule.parse.JunctionParser;
import com.bstek.urule.parse.SimpleArithmeticParser;
import com.bstek.urule.parse.ValueParser;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class LeftParser
extends AbstractParser<Left> {
    private ComplexArithmeticParser a;
    private SimpleArithmeticParser b;
    private ValueParser c;
    private JunctionParser d;

    @Override
    public Left parse(Element element) {
        Left left = new Left();
        String string = element.attributeValue("type");
        if (StringUtils.isNotEmpty((String)string)) {
            left.setType(LeftType.valueOf(string));
        } else {
            left.setType(LeftType.variable);
        }
        switch (left.getType()) {
            case variable: {
                left.setLeftPart(this.g(element));
                break;
            }
            case function: {
                left.setLeftPart(this.f(element));
                break;
            }
            case method: {
                left.setLeftPart(this.e(element));
                break;
            }
            case parameter: {
                left.setLeftPart(this.g(element));
                break;
            }
            case commonfunction: {
                left.setLeftPart(this.d(element));
                break;
            }
            case operatecollection: {
                left.setLeftPart(this.a(element));
                break;
            }
            case all: {
                throw new RuleException("Not support all type.");
            }
            case exist: {
                throw new RuleException("Not support exist type.");
            }
            case collect: {
                throw new RuleException("Not support collect type.");
            }
            case eval: {
                throw new RuleException("Not support eval type.");
            }
        }
        for (Object e : element.elements()) {
            if (e == null || !(e instanceof Element)) continue;
            Element element2 = (Element)e;
            String string2 = element2.getName();
            if (this.a.support(string2)) {
                left.setArithmetic(this.a.parse(element2));
                continue;
            }
            if (!this.b.support(string2)) continue;
            SimpleArithmetic simpleArithmetic = this.b.parse(element2);
            left.setArithmetic(this.a(simpleArithmetic));
        }
        return left;
    }

    private AccumulateLeftPart a(Element element) {
        for (Object e : element.elements()) {
            Element element2;
            if (e == null || !(e instanceof Element) || !(element2 = (Element)e).getName().equals("accumulate")) continue;
            return this.b(element2);
        }
        return null;
    }

    private AccumulateLeftPart b(Element element) {
        AccumulateLeftPart accumulateLeftPart = new AccumulateLeftPart();
        ArrayList<ConditionItem> arrayList = new ArrayList<ConditionItem>();
        ArrayList<CalculateItem> arrayList2 = new ArrayList<CalculateItem>();
        accumulateLeftPart.setCalculateItems(arrayList2);
        accumulateLeftPart.setConditionItems(arrayList);
        String string = element.attributeValue("target-type");
        LoopTargetType loopTargetType = LoopTargetType.valueOf(string);
        accumulateLeftPart.setLoopTargetType(loopTargetType);
        for (Object e : element.elements()) {
            Object object;
            Object object2;
            if (e == null || !(e instanceof Element)) continue;
            Element element2 = (Element)e;
            if (element2.getName().equals("value")) {
                object2 = this.c.parse(element2);
                object = new LoopTarget();
                ((LoopTarget)object).setValue((Value)object2);
                accumulateLeftPart.setLoopTarget((LoopTarget)object);
                continue;
            }
            if (element2.getName().equals("condition")) {
                object2 = new ConditionItem();
                arrayList.add((ConditionItem)object2);
                ((ConditionItem)object2).setLeft(element2.attributeValue("left"));
                ((ConditionItem)object2).setOp(Op.valueOf(element2.attributeValue("op")));
                ((ConditionItem)object2).setValue(this.c(element2));
                continue;
            }
            if (element2.getName().equals("calculate")) {
                object2 = new CalculateItem();
                arrayList2.add((CalculateItem)object2);
                ((CalculateItem)object2).setType(CalculateType.valueOf(element2.attributeValue("type")));
                object = element2.attributeValue("enable-assignment");
                ((CalculateItem)object2).setEnableAssignment(Boolean.valueOf((String)object));
                if (((CalculateItem)object2).isEnableAssignment()) {
                    ((CalculateItem)object2).setAssignTargetType(element2.attributeValue("assign-target-type"));
                    ((CalculateItem)object2).setAssignCategoryUuid(element2.attributeValue("category-uuid"));
                    ((CalculateItem)object2).setAssignVariableCategory(element2.attributeValue("var-category"));
                    ((CalculateItem)object2).setAssignVariableUuid(element2.attributeValue("uuid"));
                    ((CalculateItem)object2).setAssignVariable(element2.attributeValue("var"));
                    ((CalculateItem)object2).setAssignVariableLabel(element2.attributeValue("var-label"));
                    ((CalculateItem)object2).setKeyLabel(element2.attributeValue("key-label"));
                    ((CalculateItem)object2).setKeyName(element2.attributeValue("key-name"));
                    String string2 = element2.attributeValue("datatype");
                    if (StringUtils.isNotBlank((String)string2)) {
                        ((CalculateItem)object2).setAssignDatatype(Datatype.valueOf(string2));
                    }
                }
                ((CalculateItem)object2).setValue(this.c(element2));
                continue;
            }
            if (!element2.getName().equals("and") && !element2.getName().equals("or")) continue;
            object2 = (Junction)this.d.parse(element2);
            accumulateLeftPart.setJunction((Junction)object2);
        }
        return accumulateLeftPart;
    }

    private Value c(Element element) {
        for (Object e : element.elements()) {
            Element element2;
            if (e == null || !(e instanceof Element) || !(element2 = (Element)e).getName().equals("value")) continue;
            return this.c.parse(element2);
        }
        return null;
    }

    private ComplexArithmetic a(SimpleArithmetic simpleArithmetic) {
        if (simpleArithmetic == null) {
            return null;
        }
        ComplexArithmetic complexArithmetic = new ComplexArithmetic();
        complexArithmetic.setType(simpleArithmetic.getType());
        SimpleValue simpleValue = new SimpleValue();
        complexArithmetic.setValue(simpleValue);
        SimpleArithmeticValue simpleArithmeticValue = simpleArithmetic.getValue();
        simpleValue.setContent(simpleArithmeticValue.getContent());
        SimpleArithmetic simpleArithmetic2 = simpleArithmeticValue.getArithmetic();
        simpleValue.setArithmetic(this.a(simpleArithmetic2));
        return complexArithmetic;
    }

    private CommonFunctionLeftPart d(Element element) {
        CommonFunctionLeftPart commonFunctionLeftPart = new CommonFunctionLeftPart();
        commonFunctionLeftPart.setName(element.attributeValue("function-name"));
        commonFunctionLeftPart.setLabel(element.attributeValue("function-label"));
        for (Object e : element.elements()) {
            Element element2;
            if (!(e instanceof Element) || !(element2 = (Element)e).getName().equals("function-parameter")) continue;
            CommonFunctionParameter commonFunctionParameter = new CommonFunctionParameter();
            commonFunctionParameter.setName(element2.attributeValue("name"));
            commonFunctionParameter.setProperty(element2.attributeValue("property-name"));
            commonFunctionParameter.setPropertyLabel(element2.attributeValue("property-label"));
            for (Object e2 : element2.elements()) {
                Element element3;
                if (!(e2 instanceof Element) || !(element3 = (Element)e2).getName().equals("value")) continue;
                commonFunctionParameter.setObjectParameter(this.c.parse(element3));
            }
            commonFunctionLeftPart.setParameter(commonFunctionParameter);
        }
        return commonFunctionLeftPart;
    }

    private MethodLeftPart e(Element element) {
        MethodLeftPart methodLeftPart = new MethodLeftPart();
        methodLeftPart.setBeanId(element.attributeValue("bean-name"));
        methodLeftPart.setBeanLabel(element.attributeValue("bean-label"));
        methodLeftPart.setUuid(element.attributeValue("uuid"));
        methodLeftPart.setCategoryUuid(element.attributeValue("category-uuid"));
        methodLeftPart.setMethodLabel(element.attributeValue("method-label"));
        methodLeftPart.setMethodName(element.attributeValue("method-name"));
        methodLeftPart.setParameters(this.a(element, this.c));
        return methodLeftPart;
    }

    private FunctionLeftPart f(Element element) {
        FunctionLeftPart functionLeftPart = new FunctionLeftPart();
        functionLeftPart.setName(element.attributeValue("name"));
        functionLeftPart.setParameters(this.a(element, this.c));
        return functionLeftPart;
    }

    private VariableLeftPart g(Element element) {
        String string;
        VariableLeftPart variableLeftPart = new VariableLeftPart();
        variableLeftPart.setCategoryUuid(element.attributeValue("category-uuid"));
        variableLeftPart.setUuid(element.attributeValue("uuid"));
        variableLeftPart.setVariableName(element.attributeValue("var"));
        variableLeftPart.setVariableLabel(element.attributeValue("var-label"));
        String string2 = element.attributeValue("var-category");
        if (StringUtils.isNotEmpty((String)string2)) {
            variableLeftPart.setVariableCategory(string2);
        }
        if (StringUtils.isNotEmpty((String)(string = element.attributeValue("datatype")))) {
            try {
                variableLeftPart.setDatatype(Datatype.valueOf(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        variableLeftPart.setKeyName(element.attributeValue("key-name"));
        variableLeftPart.setKeyLabel(element.attributeValue("key-label"));
        variableLeftPart.setKeyCategoryUuid(element.attributeValue("key-category-uuid"));
        variableLeftPart.setKeyUuid(element.attributeValue("key-uuid"));
        return variableLeftPart;
    }

    public void setJunctionParser(JunctionParser junctionParser) {
        this.d = junctionParser;
    }

    public void setValueParser(ValueParser valueParser) {
        this.c = valueParser;
    }

    public void setComplexArithmeticParser(ComplexArithmeticParser complexArithmeticParser) {
        this.a = complexArithmeticParser;
    }

    public void setSimpleArithmeticParser(SimpleArithmeticParser simpleArithmeticParser) {
        this.b = simpleArithmeticParser;
    }

    @Override
    public boolean support(String string) {
        return string.equals("left");
    }
}

