/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.crosstab;

import com.bstek.urule.Configure;
import com.bstek.urule.builder.ResourceLibraryBuilder;
import com.bstek.urule.builder.RulesRebuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.crosstab.BundleData;
import com.bstek.urule.model.crosstab.ConditionCrossCell;
import com.bstek.urule.model.crosstab.CrossCell;
import com.bstek.urule.model.crosstab.CrossColumn;
import com.bstek.urule.model.crosstab.CrossRow;
import com.bstek.urule.model.crosstab.CrosstabDefinition;
import com.bstek.urule.model.crosstab.ValueCrossCell;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.library.variable.VariableData;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.table.Condition;
import com.bstek.urule.model.table.Joint;
import com.bstek.urule.parse.LibrariesParser;
import com.bstek.urule.parse.crosstab.ConditionCrossCellParser;
import com.bstek.urule.parse.crosstab.CrossColumnParser;
import com.bstek.urule.parse.crosstab.CrossRowParser;
import com.bstek.urule.parse.crosstab.HeaderCellParser;
import com.bstek.urule.parse.crosstab.ValueCrossCellParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class CrosstabParser
extends LibrariesParser<CrosstabDefinition> {
    private CrossRowParser a;
    private CrossColumnParser b;
    private HeaderCellParser c;
    private ConditionCrossCellParser d;
    private ValueCrossCellParser e;
    private RulesRebuilder f;
    private ResourceLibraryBuilder g;

    @Override
    public CrosstabDefinition parse(Element element) {
        String string;
        String string2;
        String string3;
        String string4;
        CrosstabDefinition crosstabDefinition = new CrosstabDefinition();
        crosstabDefinition.setAssignTargetType(element.attributeValue("assign-target-type"));
        crosstabDefinition.setAssignVariableCategory(element.attributeValue("var-category"));
        crosstabDefinition.setAssignVariable(element.attributeValue("var"));
        crosstabDefinition.setAssignVariableLabel(element.attributeValue("var-label"));
        crosstabDefinition.setKeyLabel(element.attributeValue("key-label"));
        crosstabDefinition.setKeyName(element.attributeValue("key-name"));
        crosstabDefinition.setKeyCategoryUuid(element.attributeValue("key-category-uuid"));
        crosstabDefinition.setKeyUuid(element.attributeValue("key-uuid"));
        crosstabDefinition.setCategoryUuid(element.attributeValue("category-uuid"));
        crosstabDefinition.setUuid(element.attributeValue("uuid"));
        String string5 = element.attributeValue("datatype");
        if (StringUtils.isNotBlank((String)string5)) {
            crosstabDefinition.setAssignDatatype(Datatype.valueOf(string5));
        }
        if (StringUtils.isNotEmpty((String)(string4 = element.attributeValue("salience")))) {
            crosstabDefinition.setSalience(Integer.valueOf(string4));
        }
        String string6 = element.attributeValue("effective-date");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Configure.getDateFormat());
        if (StringUtils.isNotEmpty((String)string6)) {
            try {
                crosstabDefinition.setEffectiveDate(simpleDateFormat.parse(string6));
            }
            catch (ParseException parseException) {
                throw new RuleException(parseException);
            }
        }
        if (StringUtils.isNotEmpty((String)(string3 = element.attributeValue("expires-date")))) {
            try {
                crosstabDefinition.setExpiresDate(simpleDateFormat.parse(string3));
            }
            catch (ParseException parseException) {
                throw new RuleException(parseException);
            }
        }
        if (StringUtils.isNotEmpty((String)(string2 = element.attributeValue("enabled")))) {
            crosstabDefinition.setEnabled(Boolean.valueOf(string2));
        }
        if (StringUtils.isNotEmpty((String)(string = element.attributeValue("debug")))) {
            crosstabDefinition.setDebug(Boolean.valueOf(string));
        }
        ArrayList<CrossCell> arrayList = new ArrayList<CrossCell>();
        ArrayList<CrossRow> arrayList2 = new ArrayList<CrossRow>();
        ArrayList<CrossColumn> arrayList3 = new ArrayList<CrossColumn>();
        crosstabDefinition.setCells(arrayList);
        crosstabDefinition.setRows(arrayList2);
        crosstabDefinition.setColumns(arrayList3);
        for (Object e : element.elements()) {
            Object object;
            if (e == null || !(e instanceof Element)) continue;
            Element element2 = (Element)e;
            String string7 = element2.getName();
            if (this.d.support(string7)) {
                arrayList.add(this.d.parse(element2));
            } else if (string7.equals("quick-test-data")) {
                object = element2.getTextTrim();
                crosstabDefinition.setQuickTestData((String)object);
            } else if (this.e.support(string7)) {
                arrayList.add(this.e.parse(element2));
            } else if (this.a.support(string7)) {
                arrayList2.add(this.a.parse(element2));
            } else if (this.b.support(string7)) {
                arrayList3.add(this.b.parse(element2));
            }
            object = this.a(element2);
            if (object != null) {
                crosstabDefinition.addLibrary((Library)object);
                continue;
            }
            if (this.c.support(string7)) {
                crosstabDefinition.setHeaderCell(this.c.parse(element2));
                continue;
            }
            if (!string7.equals("remark")) continue;
            crosstabDefinition.setRemark(element2.getText());
        }
        this.a(crosstabDefinition);
        return crosstabDefinition;
    }

    private void a(CrosstabDefinition crosstabDefinition) {
        Object object;
        List<Library> list = crosstabDefinition.getLibraries();
        ResourceLibrary resourceLibrary = this.g.buildResourceLibrary(list);
        VariableData variableData = resourceLibrary.getVariableByUuid(crosstabDefinition.getCategoryUuid(), crosstabDefinition.getUuid());
        if (variableData != null) {
            if (crosstabDefinition.getKeyUuid() == null) {
                crosstabDefinition.setAssignVariableCategory(variableData.getCategory().getName());
                crosstabDefinition.setAssignVariable(variableData.getVariable().getName());
                crosstabDefinition.setAssignVariableLabel(variableData.getVariable().getLabel());
                if (crosstabDefinition.getCategoryUuid() == null) {
                    crosstabDefinition.setCategoryUuid(variableData.getCategory().getUuid());
                    crosstabDefinition.setUuid(variableData.getVariable().getUuid());
                }
            } else {
                crosstabDefinition.setKeyLabel(variableData.getVariable().getLabel());
                crosstabDefinition.setKeyName(variableData.getVariable().getName());
                variableData = resourceLibrary.getVariableByUuid(crosstabDefinition.getKeyCategoryUuid(), crosstabDefinition.getKeyUuid());
                crosstabDefinition.setAssignVariable(variableData.getVariable().getName());
                crosstabDefinition.setAssignVariableLabel(variableData.getVariable().getLabel());
            }
        }
        List<CrossRow> list2 = crosstabDefinition.getRows();
        for (CrossRow object32 : list2) {
            if (!(object32 instanceof BundleData)) continue;
            object = (BundleData)((Object)object32);
            variableData = resourceLibrary.getVariableByUuid(((BundleData)object).getCategoryUuid(), ((BundleData)object).getUuid());
            if (variableData == null) {
                variableData = resourceLibrary.getVariableByName(((BundleData)object).getVariableCategory(), ((BundleData)object).getVariableName());
            }
            if (variableData == null) continue;
            if (((BundleData)object).getKeyUuid() == null) {
                ((BundleData)object).setVariableCategory(variableData.getCategory().getName());
                ((BundleData)object).setVariableLabel(variableData.getVariable().getLabel());
                ((BundleData)object).setVariableName(variableData.getVariable().getName());
                if (((BundleData)object).getCategoryUuid() != null) continue;
                ((BundleData)object).setCategoryUuid(variableData.getCategory().getUuid());
                ((BundleData)object).setUuid(variableData.getVariable().getUuid());
                continue;
            }
            ((BundleData)object).setKeyLabel(variableData.getVariable().getLabel());
            ((BundleData)object).setKeyName(variableData.getVariable().getName());
            variableData = resourceLibrary.getVariableByUuid(((BundleData)object).getKeyCategoryUuid(), ((BundleData)object).getKeyUuid());
            ((BundleData)object).setVariableLabel(variableData.getVariable().getLabel());
            ((BundleData)object).setVariableName(variableData.getVariable().getName());
        }
        List<CrossColumn> list3 = crosstabDefinition.getColumns();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            object = (CrossColumn)iterator.next();
            if (!(object instanceof BundleData)) continue;
            Object object2 = (BundleData)object;
            variableData = resourceLibrary.getVariableByUuid(((BundleData)object2).getCategoryUuid(), ((BundleData)object2).getUuid());
            if (variableData == null) {
                variableData = resourceLibrary.getVariableByName(((BundleData)object2).getVariableCategory(), ((BundleData)object2).getVariableName());
            }
            if (variableData == null) continue;
            if (((BundleData)object2).getKeyUuid() == null) {
                ((BundleData)object2).setVariableCategory(variableData.getCategory().getName());
                ((BundleData)object2).setVariableLabel(variableData.getVariable().getLabel());
                ((BundleData)object2).setVariableName(variableData.getVariable().getName());
                if (((BundleData)object2).getCategoryUuid() != null) continue;
                ((BundleData)object2).setCategoryUuid(variableData.getCategory().getUuid());
                ((BundleData)object2).setUuid(variableData.getVariable().getUuid());
                continue;
            }
            ((BundleData)object2).setKeyLabel(variableData.getVariable().getLabel());
            ((BundleData)object2).setKeyName(variableData.getVariable().getName());
            variableData = resourceLibrary.getVariableByUuid(((BundleData)object2).getKeyCategoryUuid(), ((BundleData)object2).getKeyUuid());
            ((BundleData)object2).setVariableLabel(variableData.getVariable().getLabel());
            ((BundleData)object2).setVariableName(variableData.getVariable().getName());
        }
        List<CrossCell> list4 = crosstabDefinition.getCells();
        for (Object object2 : list4) {
            Object object3;
            CrossCell crossCell;
            if (object2 instanceof ConditionCrossCell) {
                crossCell = (ConditionCrossCell)object2;
                object3 = ((ConditionCrossCell)crossCell).getJoint();
                this.a((Joint)object3, resourceLibrary);
                continue;
            }
            if (!(object2 instanceof ValueCrossCell) || (object3 = ((ValueCrossCell)(crossCell = (ValueCrossCell)object2)).getValue()) == null) continue;
            this.f.rebuildValue((Value)object3, resourceLibrary, false);
        }
    }

    private void a(Joint joint, ResourceLibrary resourceLibrary) {
        Object object;
        Object object2;
        Object object3;
        if (joint == null) {
            return;
        }
        List<Condition> list = joint.getConditions();
        if (list != null) {
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (Condition)object3.next();
                object = ((Condition)object2).getValue();
                if (object == null) continue;
                this.f.rebuildValue((Value)object, resourceLibrary, false);
            }
        }
        if ((object3 = joint.getJoints()) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Joint)object2.next();
                this.a((Joint)object, resourceLibrary);
            }
        }
    }

    @Override
    public boolean support(String string) {
        return "crosstab".equals(string);
    }

    public void setRulesRebuilder(RulesRebuilder rulesRebuilder) {
        this.f = rulesRebuilder;
    }

    public void setResourceLibraryBuilder(ResourceLibraryBuilder resourceLibraryBuilder) {
        this.g = resourceLibraryBuilder;
    }

    public void setConditionCrossCellParser(ConditionCrossCellParser conditionCrossCellParser) {
        this.d = conditionCrossCellParser;
    }

    public void setCrossColumnParser(CrossColumnParser crossColumnParser) {
        this.b = crossColumnParser;
    }

    public void setCrossRowParser(CrossRowParser crossRowParser) {
        this.a = crossRowParser;
    }

    public void setHeaderCellParser(HeaderCellParser headerCellParser) {
        this.c = headerCellParser;
    }

    public void setValueCrossCellParser(ValueCrossCellParser valueCrossCellParser) {
        this.e = valueCrossCellParser;
    }
}

