/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.flow;

import com.bstek.urule.action.Action;
import com.bstek.urule.builder.RulesRebuilder;
import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.flow.ScriptNode;
import com.bstek.urule.model.flow.StartNode;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.parse.LibrariesParser;
import com.bstek.urule.parse.flow.FlowNodeParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FlowDefinitionParser
extends LibrariesParser<FlowDefinition>
implements ApplicationContextAware {
    private RulesRebuilder a;
    private Collection<FlowNodeParser> b;

    @Override
    public FlowDefinition parse(Element element) {
        FlowDefinition flowDefinition = new FlowDefinition();
        flowDefinition.setId(element.attributeValue("id"));
        String string = element.attributeValue("debug");
        if (StringUtils.isNotBlank((String)string)) {
            flowDefinition.setDebug(Boolean.valueOf(string));
        }
        ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>();
        block0: for (Object e : element.elements()) {
            if (e == null || !(e instanceof Element)) continue;
            Element element2 = (Element)e;
            String string2 = element2.getName();
            Library library = this.a(element2);
            if (library != null) {
                flowDefinition.addLibrary(library);
                continue;
            }
            if (string2.equals("quick-test-data")) {
                String string3 = element2.getTextTrim();
                flowDefinition.setQuickTestData(string3);
                continue;
            }
            for (FlowNodeParser flowNodeParser : this.b) {
                if (!flowNodeParser.support(element2.getName())) continue;
                FlowNode flowNode = (FlowNode)flowNodeParser.parse(element2);
                arrayList.add(flowNode);
                if (!(flowNode instanceof StartNode)) continue block0;
                flowDefinition.setStartNode((StartNode)flowNode);
                continue block0;
            }
        }
        flowDefinition.setNodes(arrayList);
        flowDefinition.buildConnectionToNode();
        this.a(flowDefinition);
        return flowDefinition;
    }

    private void a(FlowDefinition flowDefinition) {
        List<Library> list = flowDefinition.getLibraries();
        if (list == null) {
            return;
        }
        ResourceLibrary resourceLibrary = this.a.getResourceLibraryBuilder().buildResourceLibrary(list);
        List<FlowNode> list2 = flowDefinition.getNodes();
        for (FlowNode flowNode : list2) {
            ScriptNode scriptNode;
            List<Action> list3;
            if (!(flowNode instanceof ScriptNode) || (list3 = (scriptNode = (ScriptNode)flowNode).getActionsData()) == null) continue;
            for (Action action : list3) {
                this.a.rebuildAction(action, resourceLibrary, false);
            }
        }
    }

    @Override
    public boolean support(String string) {
        return string.equals("rule-flow");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.b = applicationContext.getBeansOfType(FlowNodeParser.class).values();
    }

    public void setRulesRebuilder(RulesRebuilder rulesRebuilder) {
        this.a = rulesRebuilder;
    }
}

