/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.scorecard;

import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.scorecard.CardCell;
import com.bstek.urule.model.scorecard.CellType;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.ValueParser;
import com.bstek.urule.parse.table.JointParser;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class CardCellParser
implements Parser<CardCell> {
    private ValueParser a;
    private JointParser b;

    @Override
    public CardCell parse(Element element) {
        CardCell cardCell = new CardCell();
        cardCell.setType(CellType.valueOf(element.attributeValue("type")));
        cardCell.setCol(Integer.valueOf(element.attributeValue("col")));
        cardCell.setRow(Integer.valueOf(element.attributeValue("row")));
        String string = element.attributeValue("datatype");
        if (StringUtils.isNotBlank((String)string)) {
            cardCell.setDatatype(Datatype.valueOf(string));
        }
        cardCell.setVariableName(element.attributeValue("var"));
        cardCell.setVariableLabel(element.attributeValue("var-label"));
        cardCell.setUuid(element.attributeValue("uuid"));
        cardCell.setKeyLabel(element.attributeValue("key-label"));
        cardCell.setKeyName(element.attributeValue("key-name"));
        cardCell.setWeight(element.attributeValue("weight"));
        for (Object e : element.elements()) {
            if (e == null || !(e instanceof Element)) continue;
            Element element2 = (Element)e;
            if (this.a.support(element2.getName())) {
                cardCell.setValue(this.a.parse(element2));
                continue;
            }
            if (!this.b.support(element2.getName())) continue;
            cardCell.setJoint(this.b.parse(element2));
        }
        return cardCell;
    }

    public void setJointParser(JointParser jointParser) {
        this.b = jointParser;
    }

    public void setValueParser(ValueParser valueParser) {
        this.a = valueParser;
    }

    @Override
    public boolean support(String string) {
        return string.equals("card-cell");
    }
}

