/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.scorecard;

import com.bstek.urule.Configure;
import com.bstek.urule.builder.RulesRebuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.library.variable.VariableData;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.scorecard.AssignTargetType;
import com.bstek.urule.model.scorecard.ComplexColumn;
import com.bstek.urule.model.scorecard.ComplexColumnType;
import com.bstek.urule.model.scorecard.ComplexScorecardDefinition;
import com.bstek.urule.model.scorecard.ScoringType;
import com.bstek.urule.model.table.Cell;
import com.bstek.urule.model.table.Condition;
import com.bstek.urule.model.table.Row;
import com.bstek.urule.parse.LibrariesParser;
import com.bstek.urule.parse.scorecard.ComplexColumnParser;
import com.bstek.urule.parse.table.CellParser;
import com.bstek.urule.parse.table.RowParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ComplexScorecardParser
extends LibrariesParser<ComplexScorecardDefinition> {
    private RowParser a;
    private ComplexColumnParser b;
    private CellParser c;
    private RulesRebuilder d;

    @Override
    public ComplexScorecardDefinition parse(Element element) {
        String string;
        String string2;
        String string3;
        String string4;
        ComplexScorecardDefinition complexScorecardDefinition = new ComplexScorecardDefinition();
        complexScorecardDefinition.setScoringType(ScoringType.valueOf(element.attributeValue("scoring-type")));
        complexScorecardDefinition.setScoringBean(element.attributeValue("custom-scoring-bean"));
        complexScorecardDefinition.setAssignTargetType(AssignTargetType.valueOf(element.attributeValue("assign-target-type")));
        complexScorecardDefinition.setVariableCategory(element.attributeValue("var-category"));
        complexScorecardDefinition.setVariableName(element.attributeValue("var"));
        complexScorecardDefinition.setVariableLabel(element.attributeValue("var-label"));
        complexScorecardDefinition.setKeyLabel(element.attributeValue("key-label"));
        complexScorecardDefinition.setKeyName(element.attributeValue("key-name"));
        complexScorecardDefinition.setCategoryUuid(element.attributeValue("category-uuid"));
        complexScorecardDefinition.setUuid(element.attributeValue("uuid"));
        String string5 = element.attributeValue("datatype");
        if (StringUtils.isNotBlank((String)string5)) {
            complexScorecardDefinition.setDatatype(Datatype.valueOf(string5));
        }
        if (StringUtils.isNotEmpty((String)(string4 = element.attributeValue("salience")))) {
            complexScorecardDefinition.setSalience(Integer.valueOf(string4));
        }
        String string6 = element.attributeValue("effective-date");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Configure.getDateFormat());
        if (StringUtils.isNotEmpty((String)string6)) {
            try {
                complexScorecardDefinition.setEffectiveDate(simpleDateFormat.parse(string6));
            }
            catch (ParseException parseException) {
                throw new RuleException(parseException);
            }
        }
        if (StringUtils.isNotEmpty((String)(string3 = element.attributeValue("expires-date")))) {
            try {
                complexScorecardDefinition.setExpiresDate(simpleDateFormat.parse(string3));
            }
            catch (ParseException parseException) {
                throw new RuleException(parseException);
            }
        }
        if (StringUtils.isNotEmpty((String)(string2 = element.attributeValue("enabled")))) {
            complexScorecardDefinition.setEnabled(Boolean.valueOf(string2));
        }
        if (StringUtils.isNotEmpty((String)(string = element.attributeValue("debug")))) {
            complexScorecardDefinition.setDebug(Boolean.valueOf(string));
        }
        for (Object e : element.elements()) {
            if (e == null || !(e instanceof Element)) continue;
            Element element2 = (Element)e;
            String string7 = element2.getName();
            if (this.a.support(string7)) {
                complexScorecardDefinition.addRow(this.a.parse(element2));
            } else if (this.b.support(string7)) {
                complexScorecardDefinition.addColumn(this.b.parse(element2));
            } else if (this.c.support(string7)) {
                complexScorecardDefinition.addCell(this.c.parse(element2));
            }
            Library library = this.a(element2);
            if (library != null) {
                complexScorecardDefinition.addLibrary(library);
                continue;
            }
            if (string7.equals("quick-test-data")) {
                String string8 = element2.getTextTrim();
                complexScorecardDefinition.setQuickTestData(string8);
                continue;
            }
            if (!string7.equals("remark")) continue;
            complexScorecardDefinition.setRemark(element2.getText());
        }
        this.a(complexScorecardDefinition);
        return complexScorecardDefinition;
    }

    private void a(ComplexScorecardDefinition complexScorecardDefinition) {
        Iterator iterator;
        Object object;
        List<Library> list = complexScorecardDefinition.getLibraries();
        ResourceLibrary resourceLibrary = this.d.getResourceLibraryBuilder().buildResourceLibrary(list);
        List<ComplexColumn> list2 = complexScorecardDefinition.getColumns();
        if (list2 != null) {
            for (ComplexColumn object2 : list2) {
                object = object2.getType();
                if (!object.equals((Object)ComplexColumnType.Criteria) || (iterator = resourceLibrary.getVariableCategoryByUuid(object2.getUuid())) == null) continue;
                object2.setVariableCategory(((VariableCategory)((Object)iterator)).getName());
            }
        }
        for (Cell cell : complexScorecardDefinition.getCellMap().values()) {
            Object object2;
            if (cell.getAction() != null) {
                this.d.rebuildAction(cell.getAction(), resourceLibrary, false);
            } else if (cell.getValue() != null) {
                this.d.rebuildValue(cell.getValue(), resourceLibrary, false);
            } else if (cell.getJoint() != null && cell.getJoint() != null && cell.getJoint().getJunction() != null && (object = cell.getJoint().getConditions()) != null) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    object2 = (Condition)iterator.next();
                    Value value = ((Condition)object2).getValue();
                    if (value == null) continue;
                    this.d.rebuildValue(value, resourceLibrary, false);
                }
            }
            if (cell.getUuid() == null || (iterator = resourceLibrary.getVariableByUuid((String)(object = this.a(list2, cell.getCol())), cell.getUuid())) == null) continue;
            if (cell.getKeyCategoryUuid() != null) {
                object2 = resourceLibrary.getVariableByUuid(cell.getKeyCategoryUuid(), cell.getKeyUuid());
                cell.setDatatype(((VariableData)object2).getVariable().getType());
                cell.setVariableName(((VariableData)object2).getVariable().getName());
                cell.setVariableLabel(((VariableData)object2).getVariable().getLabel());
                cell.setKeyLabel(((VariableData)((Object)iterator)).getVariable().getLabel());
                cell.setKeyName(((VariableData)((Object)iterator)).getVariable().getName());
                continue;
            }
            cell.setDatatype(((VariableData)((Object)iterator)).getVariable().getType());
            cell.setVariableName(((VariableData)((Object)iterator)).getVariable().getName());
            cell.setVariableLabel(((VariableData)((Object)iterator)).getVariable().getLabel());
        }
        Collections.sort(complexScorecardDefinition.getColumns(), new Comparator<ComplexColumn>(){

            @Override
            public int compare(ComplexColumn complexColumn, ComplexColumn complexColumn2) {
                return complexColumn.getNum() - complexColumn2.getNum();
            }
        });
        Collections.sort(complexScorecardDefinition.getRows(), new Comparator<Row>(){

            @Override
            public int compare(Row row, Row row2) {
                return row.getNum() - row2.getNum();
            }
        });
    }

    private String a(List<ComplexColumn> list, int n) {
        if (list != null) {
            for (ComplexColumn complexColumn : list) {
                if (complexColumn.getNum() != n) continue;
                return complexColumn.getUuid();
            }
        }
        return null;
    }

    @Override
    public boolean support(String string) {
        return string.equals("complex-scorecard");
    }

    public void setColumnParser(ComplexColumnParser complexColumnParser) {
        this.b = complexColumnParser;
    }

    public void setRowParser(RowParser rowParser) {
        this.a = rowParser;
    }

    public void setCellParser(CellParser cellParser) {
        this.c = cellParser;
    }

    public void setRulesRebuilder(RulesRebuilder rulesRebuilder) {
        this.d = rulesRebuilder;
    }
}

