/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.scorecard;

import com.bstek.urule.Configure;
import com.bstek.urule.builder.RulesRebuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.library.variable.VariableData;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.scorecard.AssignTargetType;
import com.bstek.urule.model.scorecard.AttributeRow;
import com.bstek.urule.model.scorecard.CardCell;
import com.bstek.urule.model.scorecard.CellType;
import com.bstek.urule.model.scorecard.CustomCol;
import com.bstek.urule.model.scorecard.ScorecardDefinition;
import com.bstek.urule.model.scorecard.ScoringType;
import com.bstek.urule.model.table.Condition;
import com.bstek.urule.model.table.Joint;
import com.bstek.urule.parse.LibrariesParser;
import com.bstek.urule.parse.scorecard.AttributeRowParser;
import com.bstek.urule.parse.scorecard.CardCellParser;
import com.bstek.urule.parse.scorecard.CustomColParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ScorecardParser
extends LibrariesParser<ScorecardDefinition> {
    private CardCellParser a;
    private AttributeRowParser b = new AttributeRowParser();
    private CustomColParser c = new CustomColParser();
    private RulesRebuilder d;

    @Override
    public ScorecardDefinition parse(Element element) {
        String string;
        String string2;
        String string3;
        ScorecardDefinition scorecardDefinition = new ScorecardDefinition();
        scorecardDefinition.setName(element.attributeValue("name"));
        scorecardDefinition.setScoringType(ScoringType.valueOf(element.attributeValue("scoring-type")));
        scorecardDefinition.setAssignTargetType(AssignTargetType.valueOf(element.attributeValue("assign-target-type")));
        scorecardDefinition.setVariableCategory(element.attributeValue("var-category"));
        scorecardDefinition.setVariableName(element.attributeValue("var"));
        scorecardDefinition.setVariableLabel(element.attributeValue("var-label"));
        scorecardDefinition.setUuid(element.attributeValue("uuid"));
        scorecardDefinition.setCategoryUuid(element.attributeValue("category-uuid"));
        scorecardDefinition.setKeyUuid(element.attributeValue("key-uuid"));
        scorecardDefinition.setKeyCategoryUuid(element.attributeValue("key-category-uuid"));
        String string4 = element.attributeValue("datatype");
        if (StringUtils.isNotBlank((String)string4)) {
            scorecardDefinition.setDatatype(Datatype.valueOf(string4));
        }
        scorecardDefinition.setKeyLabel(element.attributeValue("key-label"));
        scorecardDefinition.setKeyName(element.attributeValue("key-name"));
        scorecardDefinition.setScoringBean(element.attributeValue("custom-scoring-bean"));
        String string5 = element.attributeValue("salience");
        if (StringUtils.isNotEmpty((String)string5)) {
            scorecardDefinition.setSalience(Integer.valueOf(string5));
        }
        String string6 = element.attributeValue("effective-date");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Configure.getDateFormat());
        if (StringUtils.isNotEmpty((String)string6)) {
            try {
                scorecardDefinition.setEffectiveDate(simpleDateFormat.parse(string6));
            }
            catch (ParseException parseException) {
                throw new RuleException(parseException);
            }
        }
        if (StringUtils.isNotEmpty((String)(string3 = element.attributeValue("expires-date")))) {
            try {
                scorecardDefinition.setExpiresDate(simpleDateFormat.parse(string3));
            }
            catch (ParseException parseException) {
                throw new RuleException(parseException);
            }
        }
        if (StringUtils.isNotEmpty((String)(string2 = element.attributeValue("enabled")))) {
            scorecardDefinition.setEnabled(Boolean.valueOf(string2));
        }
        if (StringUtils.isNotEmpty((String)(string = element.attributeValue("debug")))) {
            scorecardDefinition.setDebug(Boolean.valueOf(string));
        }
        scorecardDefinition.setAttributeColWidth(element.attributeValue("attr-col-width"));
        scorecardDefinition.setAttributeColName(element.attributeValue("attr-col-name"));
        scorecardDefinition.setAttributeColVariableCategory(element.attributeValue("attr-col-category"));
        scorecardDefinition.setAttributeColVariableCategoryUuid(element.attributeValue("attr-col-category-uuid"));
        scorecardDefinition.setConditionColName(element.attributeValue("condition-col-name"));
        scorecardDefinition.setConditionColWidth(element.attributeValue("condition-col-width"));
        scorecardDefinition.setScoreColName(element.attributeValue("score-col-name"));
        scorecardDefinition.setScoreColWidth(element.attributeValue("score-col-width"));
        String string7 = element.attributeValue("weight-support");
        if (StringUtils.isNotBlank((String)string7)) {
            scorecardDefinition.setWeightSupport(Boolean.valueOf(string7));
        }
        ArrayList<CardCell> arrayList = new ArrayList<CardCell>();
        ArrayList<AttributeRow> arrayList2 = new ArrayList<AttributeRow>();
        ArrayList<CustomCol> arrayList3 = new ArrayList<CustomCol>();
        scorecardDefinition.setCells(arrayList);
        scorecardDefinition.setRows(arrayList2);
        scorecardDefinition.setCustomCols(arrayList3);
        for (Object e : element.elements()) {
            Object object;
            if (e == null || !(e instanceof Element)) continue;
            Element element2 = (Element)e;
            String string8 = element2.getName();
            if (this.a.support(string8)) {
                arrayList.add(this.a.parse(element2));
            } else if (this.b.support(string8)) {
                arrayList2.add(this.b.parse(element2));
            } else if (this.c.support(string8)) {
                arrayList3.add(this.c.parse(element2));
            } else if (string8.equals("quick-test-data")) {
                object = element2.getTextTrim();
                scorecardDefinition.setQuickTestData((String)object);
            }
            object = this.a(element2);
            if (object != null) {
                scorecardDefinition.addLibrary((Library)object);
                continue;
            }
            if (!string8.equals("remark")) continue;
            scorecardDefinition.setRemark(element2.getText());
        }
        this.a(scorecardDefinition);
        return scorecardDefinition;
    }

    private void a(ScorecardDefinition scorecardDefinition) {
        Object object;
        List<Library> list = scorecardDefinition.getLibraries();
        if (list == null) {
            return;
        }
        ResourceLibrary resourceLibrary = this.d.getResourceLibraryBuilder().buildResourceLibrary(list);
        VariableCategory variableCategory = resourceLibrary.getVariableCategoryByUuid(scorecardDefinition.getAttributeColVariableCategoryUuid());
        if (variableCategory == null) {
            variableCategory = resourceLibrary.getVariableCategoryByCategoryName(scorecardDefinition.getAttributeColVariableCategory());
        }
        scorecardDefinition.setAttributeColVariableCategory(variableCategory.getName());
        if (!scorecardDefinition.getAssignTargetType().equals((Object)AssignTargetType.none)) {
            if (scorecardDefinition.getKeyCategoryUuid() != null) {
                object = resourceLibrary.getVariableByUuid(scorecardDefinition.getKeyCategoryUuid(), scorecardDefinition.getKeyUuid());
                scorecardDefinition.setVariableLabel(((VariableData)object).getVariable().getLabel());
                scorecardDefinition.setDatatype(((VariableData)object).getVariable().getType());
                scorecardDefinition.setVariableName(((VariableData)object).getVariable().getName());
                object = resourceLibrary.getVariableByUuid(scorecardDefinition.getCategoryUuid(), scorecardDefinition.getUuid());
                scorecardDefinition.setKeyName(((VariableData)object).getVariable().getName());
                scorecardDefinition.setKeyLabel(((VariableData)object).getVariable().getLabel());
            } else {
                object = resourceLibrary.getVariableByUuid(scorecardDefinition.getCategoryUuid(), scorecardDefinition.getUuid());
                scorecardDefinition.setVariableLabel(((VariableData)object).getVariable().getLabel());
                scorecardDefinition.setDatatype(((VariableData)object).getVariable().getType());
                scorecardDefinition.setVariableCategory(((VariableData)object).getCategory().getName());
                scorecardDefinition.setVariableName(((VariableData)object).getVariable().getName());
            }
        }
        if ((object = scorecardDefinition.getCells()) == null) {
            return;
        }
        Iterator<CardCell> iterator = object.iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object object3;
            CardCell cardCell = iterator.next();
            Joint joint = cardCell.getJoint();
            if (joint != null && joint.getConditions() != null) {
                object3 = joint.getConditions().iterator();
                while (object3.hasNext()) {
                    Value value;
                    object2 = (Condition)object3.next();
                    if (object2 == null || (value = ((Condition)object2).getValue()) == null) continue;
                    this.d.rebuildValue(value, resourceLibrary, false);
                }
            }
            if ((object3 = cardCell.getValue()) != null) {
                this.d.rebuildValue((Value)object3, resourceLibrary, false);
            }
            if (!cardCell.getType().equals((Object)CellType.attribute)) continue;
            object2 = resourceLibrary.getVariableByUuid(variableCategory.getUuid(), cardCell.getUuid());
            cardCell.setDatatype(((VariableData)object2).getVariable().getType());
            cardCell.setVariableLabel(((VariableData)object2).getVariable().getLabel());
            cardCell.setVariableName(((VariableData)object2).getVariable().getName());
        }
    }

    public void setCardCellParser(CardCellParser cardCellParser) {
        this.a = cardCellParser;
    }

    public void setRulesRebuilder(RulesRebuilder rulesRebuilder) {
        this.d = rulesRebuilder;
    }

    @Override
    public boolean support(String string) {
        return string.equals("scorecard");
    }
}

