/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.table;

import com.bstek.urule.action.Action;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.table.Cell;
import com.bstek.urule.parse.ActionParser;
import com.bstek.urule.parse.Parser;
import com.bstek.urule.parse.ValueParser;
import com.bstek.urule.parse.table.JointParser;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CellParser
implements Parser<Cell>,
ApplicationContextAware {
    private JointParser a;
    private ValueParser b;
    private Collection<ActionParser> c;

    @Override
    public Cell parse(Element element) {
        Cell cell = new Cell();
        cell.setRow(Integer.valueOf(element.attributeValue("row")));
        cell.setCol(Integer.valueOf(element.attributeValue("col")));
        cell.setRowspan(Integer.valueOf(element.attributeValue("rowspan")));
        cell.setVariableLabel(element.attributeValue("var-label"));
        cell.setVariableName(element.attributeValue("var"));
        cell.setUuid(element.attributeValue("uuid"));
        cell.setKeyLabel(element.attributeValue("key-label"));
        cell.setKeyName(element.attributeValue("key-name"));
        cell.setKeyUuid(element.attributeValue("key-uuid"));
        cell.setKeyCategoryUuid(element.attributeValue("key-category-uuid"));
        String string = element.attributeValue("datatype");
        if (StringUtils.isNotBlank((String)string)) {
            cell.setDatatype(Datatype.valueOf(string));
        }
        block0: for (Object e : element.elements()) {
            if (e == null || !(e instanceof Element)) continue;
            Element element2 = (Element)e;
            String string2 = element2.getName();
            if (this.a.support(string2)) {
                cell.setJoint(this.a.parse(element2));
                continue;
            }
            if (this.b.support(string2)) {
                cell.setValue(this.b.parse(element2));
                continue;
            }
            for (ActionParser actionParser : this.c) {
                if (!actionParser.support(string2)) continue;
                cell.setAction((Action)actionParser.parse(element2));
                continue block0;
            }
        }
        return cell;
    }

    @Override
    public boolean support(String string) {
        return string.equals("cell");
    }

    public void setJointParser(JointParser jointParser) {
        this.a = jointParser;
    }

    public void setValueParser(ValueParser valueParser) {
        this.b = valueParser;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.c = applicationContext.getBeansOfType(ActionParser.class).values();
    }
}

