/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.parse.table;

import com.bstek.urule.Configure;
import com.bstek.urule.builder.RulesRebuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.library.variable.VariableData;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.table.Cell;
import com.bstek.urule.model.table.Column;
import com.bstek.urule.model.table.Condition;
import com.bstek.urule.model.table.DecisionTable;
import com.bstek.urule.model.table.Row;
import com.bstek.urule.parse.LibrariesParser;
import com.bstek.urule.parse.table.CellParser;
import com.bstek.urule.parse.table.ColumnParser;
import com.bstek.urule.parse.table.RowParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class DecisionTableParser
extends LibrariesParser<DecisionTable> {
    private RowParser a;
    private ColumnParser b;
    private CellParser c;
    private RulesRebuilder d;

    @Override
    public DecisionTable parse(Element element) {
        String string;
        String string2;
        String string3;
        DecisionTable decisionTable = new DecisionTable();
        String string4 = element.attributeValue("salience");
        if (StringUtils.isNotEmpty((String)string4)) {
            decisionTable.setSalience(Integer.valueOf(string4));
        }
        String string5 = element.attributeValue("effective-date");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Configure.getDateFormat());
        if (StringUtils.isNotEmpty((String)string5)) {
            try {
                decisionTable.setEffectiveDate(simpleDateFormat.parse(string5));
            }
            catch (ParseException parseException) {
                throw new RuleException(parseException);
            }
        }
        if (StringUtils.isNotEmpty((String)(string3 = element.attributeValue("expires-date")))) {
            try {
                decisionTable.setExpiresDate(simpleDateFormat.parse(string3));
            }
            catch (ParseException parseException) {
                throw new RuleException(parseException);
            }
        }
        if (StringUtils.isNotEmpty((String)(string2 = element.attributeValue("enabled")))) {
            decisionTable.setEnabled(Boolean.valueOf(string2));
        }
        if (StringUtils.isNotEmpty((String)(string = element.attributeValue("debug")))) {
            decisionTable.setDebug(Boolean.valueOf(string));
        }
        for (Object e : element.elements()) {
            Object object;
            if (e == null || !(e instanceof Element)) continue;
            Element element2 = (Element)e;
            String string6 = element2.getName();
            if (this.a.support(string6)) {
                decisionTable.addRow(this.a.parse(element2));
            } else if (string6.equals("quick-test-data")) {
                object = element2.getTextTrim();
                decisionTable.setQuickTestData((String)object);
            } else if (this.b.support(string6)) {
                decisionTable.addColumn(this.b.parse(element2));
            } else if (this.c.support(string6)) {
                decisionTable.addCell(this.c.parse(element2));
            }
            object = this.a(element2);
            if (object != null) {
                decisionTable.addLibrary((Library)object);
                continue;
            }
            if (!string6.equals("remark")) continue;
            decisionTable.setRemark(element2.getText());
        }
        this.a(decisionTable);
        return decisionTable;
    }

    private void a(DecisionTable decisionTable) {
        Object object;
        Object object2;
        Object object3;
        List<Library> list = decisionTable.getLibraries();
        ResourceLibrary resourceLibrary = this.d.getResourceLibraryBuilder().buildResourceLibrary(list);
        for (Cell object4 : decisionTable.getCellMap().values()) {
            if (object4.getAction() != null) {
                this.d.rebuildAction(object4.getAction(), resourceLibrary, false);
                continue;
            }
            if (object4.getValue() != null) {
                this.d.rebuildValue(object4.getValue(), resourceLibrary, false);
                continue;
            }
            if (object4.getJoint() == null || object4.getJoint() == null || object4.getJoint().getJunction() == null || (object3 = object4.getJoint().getConditions()) == null) continue;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Condition)object2.next();
                Value value = ((Condition)object).getValue();
                if (value == null) continue;
                this.d.rebuildValue(value, resourceLibrary, false);
            }
        }
        for (Column column : decisionTable.getColumns()) {
            object3 = column.getVariableCategory();
            object2 = column.getVariableName();
            if (StringUtils.isBlank((String)object3) || StringUtils.isBlank((String)object2)) continue;
            object = resourceLibrary.getVariableByUuid(column.getCategoryUuid(), column.getUuid());
            if (object == null) {
                object = resourceLibrary.getVariableByName(column.getVariableCategory(), column.getVariableName());
            }
            if (object == null) {
                throw new RuleException("\u51b3\u7b56\u8868\u6761\u4ef6\u5217\u5934\u53d8\u91cf\u3010" + column.getVariableCategory() + "." + column.getVariableLabel() + "\u3011\u672a\u5728\u5e93\u6587\u4ef6\u4e2d\u5b9a\u4e49.");
            }
            if (column.getKeyUuid() == null) {
                column.setDatatype(((VariableData)object).getVariable().getType());
                column.setVariableName(((VariableData)object).getVariable().getName());
                column.setVariableLabel(((VariableData)object).getVariable().getLabel());
                column.setVariableCategory(((VariableData)object).getCategory().getName());
                if (column.getCategoryUuid() != null) continue;
                column.setCategoryUuid(((VariableData)object).getCategory().getUuid());
                column.setUuid(((VariableData)object).getVariable().getUuid());
                continue;
            }
            column.setKeyLabel(((VariableData)object).getVariable().getLabel());
            column.setKeyName(((VariableData)object).getVariable().getName());
            object = resourceLibrary.getVariableByUuid(column.getKeyCategoryUuid(), column.getKeyUuid());
            if (object == null) continue;
            column.setVariableName(((VariableData)object).getVariable().getName());
            column.setVariableLabel(((VariableData)object).getVariable().getLabel());
            column.setDatatype(((VariableData)object).getVariable().getType());
        }
        Collections.sort(decisionTable.getColumns(), new Comparator<Column>(){

            @Override
            public int compare(Column column, Column column2) {
                return column.getNum() - column2.getNum();
            }
        });
        Collections.sort(decisionTable.getRows(), new Comparator<Row>(){

            @Override
            public int compare(Row row, Row row2) {
                return row.getNum() - row2.getNum();
            }
        });
    }

    @Override
    public boolean support(String string) {
        return string.equals("decision-table");
    }

    public void setColumnParser(ColumnParser columnParser) {
        this.b = columnParser;
    }

    public void setRowParser(RowParser rowParser) {
        this.a = rowParser;
    }

    public void setCellParser(CellParser cellParser) {
        this.c = cellParser;
    }

    public void setRulesRebuilder(RulesRebuilder rulesRebuilder) {
        this.d = rulesRebuilder;
    }
}

