/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime;

import com.bstek.urule.model.Node;
import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.Line;
import com.bstek.urule.model.rete.MutexReteUnit;
import com.bstek.urule.model.rete.ObjectTypeNode;
import com.bstek.urule.model.rete.Rete;
import com.bstek.urule.model.rete.ReteNode;
import com.bstek.urule.model.rete.ReteUnit;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.monitor.MonitorObject;
import com.bstek.urule.runtime.rete.ReteInstance;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class KnowledgePackageImpl
implements KnowledgePackage {
    private String packageInfo;
    private boolean monitor;
    private List<MonitorObject> inputData;
    private List<MonitorObject> outputData;
    private String version;
    private String versionComment;
    private Date versionCreateDate;
    private String versionCreateUser;
    private Rete rete;
    private List<Rete> aloneRetes;
    private Map<String, String> variableCategoryMap = new HashMap<String, String>();
    @JsonIgnore
    private Map<String, VariableCategory> variableCategoryWithDefaultValueClassMap = new HashMap<String, VariableCategory>();
    private Map<String, FlowDefinition> flowMap;
    private Map<String, String> parameters;
    private long timestamp;
    private String id = UUID.randomUUID().toString();
    private List<VariableCategory> variableCategories;

    public KnowledgePackageImpl() {
        this.timestamp = System.currentTimeMillis();
    }

    public void initForActiveVersion() {
        this.initSingleReteForActiveVersion(this.rete);
        if (this.flowMap == null) {
            return;
        }
        for (FlowDefinition object : this.flowMap.values()) {
            object.initForActiveVersion();
        }
        if (this.aloneRetes == null) {
            return;
        }
        for (Rete rete : this.aloneRetes) {
            this.initSingleReteForActiveVersion(rete);
        }
    }

    private void initSingleReteForActiveVersion(Rete rete) {
        this.initReteForActiveVersion(rete);
        this.initReteUnitsForActiveVersion(rete.getMutexGroupRetesMap());
        this.initReteUnitsForActiveVersion(rete.getPendedGroupRetesMap());
    }

    private void initReteUnitsForActiveVersion(Map<String, List<ReteUnit>> map) {
        if (map == null) {
            return;
        }
        for (List<ReteUnit> list : map.values()) {
            for (ReteUnit reteUnit : list) {
                Object object;
                if (reteUnit instanceof MutexReteUnit) {
                    object = (MutexReteUnit)reteUnit;
                    for (ReteUnit reteUnit2 : ((MutexReteUnit)object).getList()) {
                        Rete rete = reteUnit2.getRete();
                        if (rete == null) continue;
                        this.initReteForActiveVersion(rete);
                    }
                    continue;
                }
                object = reteUnit.getRete();
                this.initReteForActiveVersion((Rete)object);
            }
        }
    }

    private void initReteForActiveVersion(Rete rete) {
        List<ObjectTypeNode> list = rete.getObjectTypeNodes();
        for (BaseReteNode object : list) {
            this.buildChildrenNodes(object);
        }
        if (this.flowMap == null) {
            return;
        }
        for (FlowDefinition flowDefinition : this.flowMap.values()) {
            flowDefinition.initForActiveVersion();
        }
    }

    private void buildChildrenNodes(BaseReteNode baseReteNode) {
        List<Line> list = baseReteNode.getLines();
        if (list == null) {
            return;
        }
        for (Line line : list) {
            Node node = line.getTo();
            if (node instanceof ReteNode) {
                baseReteNode.getChildrenNodes().add((ReteNode)node);
            }
            if (!(node instanceof BaseReteNode)) continue;
            BaseReteNode baseReteNode2 = (BaseReteNode)node;
            this.buildChildrenNodes(baseReteNode2);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Rete getRete() {
        return this.rete;
    }

    public void setRete(Rete rete) {
        this.rete = rete;
    }

    @Override
    public List<Rete> getAloneRetes() {
        return this.aloneRetes;
    }

    public void setAloneRetes(List<Rete> list) {
        this.aloneRetes = list;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    @Override
    public void resetTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public String getPackageInfo() {
        return this.packageInfo;
    }

    public void setPackageInfo(String string) {
        this.packageInfo = string;
    }

    public void setMonitor(boolean bl) {
        this.monitor = bl;
    }

    @Override
    public boolean isMonitor() {
        return this.monitor;
    }

    @Override
    public List<MonitorObject> getInputData() {
        return this.inputData;
    }

    public void setInputData(List<MonitorObject> list) {
        this.inputData = list;
    }

    @Override
    public List<MonitorObject> getOutputData() {
        return this.outputData;
    }

    public void setOutputData(List<MonitorObject> list) {
        this.outputData = list;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    @Override
    public String getVersionComment() {
        return this.versionComment;
    }

    public void setVersionComment(String string) {
        this.versionComment = string;
    }

    @Override
    public Date getVersionCreateDate() {
        return this.versionCreateDate;
    }

    public void setVersionCreateDate(Date date) {
        this.versionCreateDate = date;
    }

    @Override
    public String getVersionCreateUser() {
        return this.versionCreateUser;
    }

    public void setVersionCreateUser(String string) {
        this.versionCreateUser = string;
    }

    @Override
    public Map<String, String> getVariableCateogoryMap() {
        return this.variableCategoryMap;
    }

    public void setVariableCategoryMap(Map<String, String> map) {
        this.variableCategoryMap = map;
    }

    @Override
    public Map<String, FlowDefinition> getFlowMap() {
        return this.flowMap;
    }

    public void setFlowMap(Map<String, FlowDefinition> map) {
        this.flowMap = map;
    }

    @Override
    public ReteInstance newReteInstance() {
        return this.rete.newReteInstance();
    }

    @Override
    public List<ReteInstance> newAloneReteInstances() {
        ArrayList<ReteInstance> arrayList = new ArrayList<ReteInstance>();
        if (this.aloneRetes == null) {
            return arrayList;
        }
        for (Rete rete : this.aloneRetes) {
            arrayList.add(rete.newReteInstance());
        }
        return arrayList;
    }

    public void setParameters(Map<String, String> map) {
        this.parameters = map;
    }

    public void setVariableCategories(List<VariableCategory> list) {
        this.variableCategories = list;
    }

    @Override
    public List<VariableCategory> getVariableCategories() {
        return this.variableCategories;
    }

    @Override
    public VariableCategory getVariableCategoryWithDefaultValue(String string) {
        return this.variableCategoryWithDefaultValueClassMap.get(string);
    }

    public void setVariableCategoryWithDefaultValueClassMap(Map<String, VariableCategory> map) {
        this.variableCategoryWithDefaultValueClassMap = map;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

