/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime;

import com.bstek.urule.builder.resource.ResourceType;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.Line;
import com.bstek.urule.model.rete.MutexReteUnit;
import com.bstek.urule.model.rete.ObjectTypeNode;
import com.bstek.urule.model.rete.Rete;
import com.bstek.urule.model.rete.ReteNode;
import com.bstek.urule.model.rete.ReteNodeJsonDeserializer;
import com.bstek.urule.model.rete.ReteUnit;
import com.bstek.urule.model.rete.RuleData;
import com.bstek.urule.model.rete.TerminalNode;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageImpl;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class KnowledgePackageWrapper {
    @JsonDeserialize(as=KnowledgePackageImpl.class)
    private KnowledgePackage knowledgePackage;
    @JsonDeserialize(using=ReteNodeJsonDeserializer.class)
    private List<ReteNode> allNodes = new ArrayList<ReteNode>();
    private Map<Integer, ReteNode> allNodeMap = new HashMap<Integer, ReteNode>();
    private String id;

    public KnowledgePackageWrapper() {
        this.id = UUID.randomUUID().toString();
    }

    public KnowledgePackageWrapper(KnowledgePackage knowledgePackage) {
        this.knowledgePackage = knowledgePackage;
        this.id = UUID.randomUUID().toString();
        this.initNodes();
    }

    private void initNodes() {
        Rete rete = this.knowledgePackage.getRete();
        this.initReteNodes(rete);
        List<Rete> list = this.knowledgePackage.getAloneRetes();
        if (list != null) {
            for (Rete rete2 : list) {
                this.initReteNodes(rete2);
            }
        }
    }

    private void initReteNodes(Rete rete) {
        List<ObjectTypeNode> list = rete.getObjectTypeNodes();
        ArrayList<ReteNode> arrayList = new ArrayList<ReteNode>();
        arrayList.addAll(list);
        this.buildChildrenNodes(arrayList, rete.getMutexGroupRetesMap());
        this.buildChildrenNodes(arrayList, rete.getPendedGroupRetesMap());
        this.queryReteNodes(arrayList);
        this.initAllRuleData(rete);
    }

    private void initAllRuleData(Rete rete) {
        ArrayList<RuleData> arrayList = new ArrayList<RuleData>();
        rete.setAllRuleData(arrayList);
        for (ReteNode reteNode : this.allNodes) {
            TerminalNode terminalNode;
            Rule rule;
            if (!(reteNode instanceof TerminalNode) || (rule = (terminalNode = (TerminalNode)reteNode).getRule()).isTargetResource(ResourceType.Flow)) continue;
            arrayList.add(new RuleData(rule));
        }
    }

    private void buildChildrenNodes(List<ReteNode> list, Map<String, List<ReteUnit>> map) {
        if (map == null) {
            return;
        }
        for (List<ReteUnit> list2 : map.values()) {
            for (ReteUnit reteUnit : list2) {
                if (reteUnit.getRete() != null) {
                    list.addAll(reteUnit.getRete().getObjectTypeNodes());
                    continue;
                }
                if (!(reteUnit instanceof MutexReteUnit)) continue;
                MutexReteUnit mutexReteUnit = (MutexReteUnit)reteUnit;
                List<ReteUnit> list3 = mutexReteUnit.getList();
                for (ReteUnit reteUnit2 : list3) {
                    if (reteUnit2.getRete() == null) continue;
                    list.addAll(reteUnit2.getRete().getObjectTypeNodes());
                }
            }
        }
    }

    private void queryReteNodes(List<ReteNode> list) {
        if (list == null) {
            return;
        }
        for (ReteNode reteNode : list) {
            if (!this.allNodes.contains(reteNode) && !(reteNode instanceof ObjectTypeNode)) {
                this.allNodes.add(reteNode);
                this.allNodeMap.put(reteNode.getId(), reteNode);
            }
            if (!(reteNode instanceof BaseReteNode)) continue;
            BaseReteNode baseReteNode = (BaseReteNode)reteNode;
            this.queryReteNodes(baseReteNode.getChildrenNodes());
        }
    }

    public void buildDeserialize() {
        List<VariableCategory> list;
        Rete rete = this.knowledgePackage.getRete();
        for (ReteNode object2 : this.allNodes) {
            if (this.allNodeMap.containsKey(object2.getId())) continue;
            this.allNodeMap.put(object2.getId(), object2);
        }
        this.buildDeserialize(rete);
        List<Rete> list2 = this.knowledgePackage.getAloneRetes();
        if (list2 != null) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                list = (Rete)iterator.next();
                this.buildDeserialize((Rete)((Object)list));
            }
        }
        HashMap<String, VariableCategory> hashMap = new HashMap<String, VariableCategory>();
        list = this.knowledgePackage.getVariableCategories();
        if (list != null) {
            for (VariableCategory variableCategory : list) {
                hashMap.put(variableCategory.getClazz(), variableCategory.newVariableCategoryWithDefaultValue());
            }
        }
        ((KnowledgePackageImpl)this.knowledgePackage).setVariableCategoryWithDefaultValueClassMap(hashMap);
    }

    private void buildDeserialize(Rete rete) {
        this.rebuildReteLine(rete);
        this.buildRetesMap(rete.getMutexGroupRetesMap());
        this.buildRetesMap(rete.getPendedGroupRetesMap());
        Map<String, FlowDefinition> map = this.knowledgePackage.getFlowMap();
        if (map != null && map.size() > 0) {
            for (FlowDefinition flowDefinition : map.values()) {
                flowDefinition.buildConnectionToNode();
            }
        }
        this.initAllRuleData(rete);
    }

    private void buildRetesMap(Map<String, List<ReteUnit>> map) {
        if (map == null) {
            return;
        }
        for (List<ReteUnit> list : map.values()) {
            for (ReteUnit reteUnit : list) {
                Object object;
                if (reteUnit instanceof MutexReteUnit) {
                    object = (MutexReteUnit)reteUnit;
                    List<ReteUnit> list2 = ((MutexReteUnit)object).getList();
                    for (ReteUnit reteUnit2 : list2) {
                        Rete rete = reteUnit2.getRete();
                        if (rete == null) continue;
                        this.rebuildReteLine(rete);
                    }
                    continue;
                }
                object = reteUnit.getRete();
                if (object == null) continue;
                this.rebuildReteLine((Rete)object);
            }
        }
    }

    private void rebuildReteLine(Rete rete) {
        List<ObjectTypeNode> list = rete.getObjectTypeNodes();
        for (ObjectTypeNode objectTypeNode : list) {
            List<Line> list2 = objectTypeNode.getLines();
            for (Line line : list2) {
                line.setFrom(objectTypeNode);
            }
            this.rebuildLine(list2, this.allNodes);
        }
    }

    private void rebuildLine(List<Line> list, List<ReteNode> list2) {
        if (list == null) {
            return;
        }
        for (Line line : list) {
            BaseReteNode baseReteNode;
            ReteNode reteNode;
            int n;
            if (line.getFrom() == null) {
                n = line.getFromNodeId();
                reteNode = this.findTargetNode(list2, n);
                line.setFrom(reteNode);
                if (reteNode instanceof BaseReteNode) {
                    baseReteNode = (BaseReteNode)reteNode;
                    this.rebuildLine(baseReteNode.getLines(), list2);
                }
            }
            if (line.getTo() != null) continue;
            n = line.getToNodeId();
            reteNode = this.findTargetNode(list2, n);
            line.setTo(reteNode);
            if (!(reteNode instanceof BaseReteNode)) continue;
            baseReteNode = (BaseReteNode)reteNode;
            this.rebuildLine(baseReteNode.getLines(), list2);
        }
    }

    private ReteNode findTargetNode(List<ReteNode> list, int n) {
        if (this.allNodeMap.containsKey(n)) {
            return this.allNodeMap.get(n);
        }
        throw new RuleException("Node[" + n + "] not exist.");
    }

    public List<ReteNode> getAllNodes() {
        return this.allNodes;
    }

    public KnowledgePackage getKnowledgePackage() {
        return this.knowledgePackage;
    }

    public String getId() {
        return this.id;
    }
}

