/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime;

import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.BatchSession;
import com.bstek.urule.runtime.BatchSessionImpl;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.KnowledgeSessionImpl;
import com.bstek.urule.runtime.rete.Context;

public class KnowledgeSessionFactory {
    public static KnowledgeSession newKnowledgeSession(KnowledgePackage knowledgePackage) {
        return new KnowledgeSessionImpl(knowledgePackage);
    }

    public static KnowledgeSession newKnowledgeSession(KnowledgePackage knowledgePackage, KnowledgeSession knowledgeSession) {
        return new KnowledgeSessionImpl(knowledgePackage, knowledgeSession);
    }

    public static KnowledgeSession newKnowledgeSession(KnowledgePackageWrapper knowledgePackageWrapper, Context context, KnowledgeSession knowledgeSession) {
        if (context == null) {
            throw new RuleException("Context cannot be null.");
        }
        if (knowledgePackageWrapper == null) {
            throw new RuleException("KnowledgePackageWrapper cannot be null.");
        }
        String string = knowledgePackageWrapper.getId();
        KnowledgeSession knowledgeSession2 = context.getWorkingMemory().getKnowledgeSession(string);
        if (knowledgeSession2 == null) {
            knowledgeSession2 = KnowledgeSessionFactory.newKnowledgeSession(knowledgePackageWrapper.getKnowledgePackage(), knowledgeSession);
            context.getWorkingMemory().putKnowledgeSession(string, knowledgeSession2);
        } else {
            knowledgeSession2.initFromParentSession(knowledgeSession);
        }
        return knowledgeSession2;
    }

    public static KnowledgeSession newKnowledgeSession(KnowledgePackage[] knowledgePackageArray) {
        return new KnowledgeSessionImpl(knowledgePackageArray, null);
    }

    public static BatchSession newBatchSession(KnowledgePackage knowledgePackage) {
        return new BatchSessionImpl(knowledgePackage, 10, 100);
    }

    public static BatchSession newBatchSessionByThreadSize(KnowledgePackage knowledgePackage, int n) {
        return new BatchSessionImpl(knowledgePackage, n, 100);
    }

    public static BatchSession newBatchSessionByBatchSize(KnowledgePackage knowledgePackage, int n) {
        return new BatchSessionImpl(knowledgePackage, 10, n);
    }

    public static BatchSession newBatchSession(KnowledgePackage knowledgePackage, int n, int n2) {
        return new BatchSessionImpl(knowledgePackage, n, n2);
    }

    public static BatchSession newBatchSession(KnowledgePackage[] knowledgePackageArray) {
        return new BatchSessionImpl(knowledgePackageArray, 10, 100);
    }

    public static BatchSession newBatchSessionByThreadSize(KnowledgePackage[] knowledgePackageArray, int n) {
        return new BatchSessionImpl(knowledgePackageArray, n, 100);
    }

    public static BatchSession newBatchSessionByBatchSize(KnowledgePackage[] knowledgePackageArray, int n) {
        return new BatchSessionImpl(knowledgePackageArray, 10, n);
    }

    public static BatchSession newBatchSession(KnowledgePackage[] knowledgePackageArray, int n, int n2) {
        return new BatchSessionImpl(knowledgePackageArray, n, n2);
    }
}

