/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.agenda;

import com.bstek.urule.Utils;
import com.bstek.urule.action.Action;
import com.bstek.urule.action.ActionType;
import com.bstek.urule.exception.RuleAssertException;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.rule.Rhs;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.loop.LoopRule;
import com.bstek.urule.model.scorecard.runtime.ScoreRule;
import com.bstek.urule.runtime.agenda.Activation;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.ExecutionContextImpl;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActivationImpl
implements Activation {
    private Rule a;
    private Set<Criteria> b;
    private Map<String, Object> c;

    public ActivationImpl(Rule rule) {
        this.a = rule;
    }

    @Override
    public void execute(Context context) {
        try {
            if (this.a.getDebug() != null && this.a.getDebug().booleanValue()) {
                context.getLogger().logExecuteRule(this.a);
            }
            context.cleanTipMsg();
            context.addTipMsg("\u6267\u884c\u89c4\u5219[" + this.a.getName() + "(" + this.a.getFile() + ")]\u52a8\u4f5c");
            ((ExecutionContextImpl)((Object)context)).setCurrentRule(this.a);
            Date date = new Date();
            Date date2 = this.a.getEffectiveDate();
            if (date2 != null && date2.compareTo(date) > 0) {
                return;
            }
            Date date3 = this.a.getExpiresDate();
            if (date3 != null && date3.compareTo(date) < 0) {
                return;
            }
            ((ExecutionContextImpl)((Object)context)).setCurrentRuleFactMap(this.c);
            ((ExecutionContextImpl)((Object)context)).setCurrentRuleCriterias(this.b);
            if (this.a instanceof LoopRule) {
                LoopRule loopRule = (LoopRule)this.a;
                loopRule.execute(context, this.c);
            } else if (this.a instanceof ScoreRule) {
                ScoreRule scoreRule = (ScoreRule)this.a;
                scoreRule.execute(context, this.c);
            } else {
                this.a(context, this.c);
            }
            context.cleanTipMsg();
        }
        catch (Exception exception) {
            String string = context.getTipMsg();
            throw new RuleAssertException(string, exception);
        }
    }

    private void a(Context context, Map<String, Object> map) {
        Rhs rhs = this.a.getRhs();
        if (rhs == null) {
            return;
        }
        List<Action> list = rhs.getActions();
        if (list == null) {
            return;
        }
        int n = 1;
        for (Action action : list) {
            if (this.a.getDebug() != null) {
                action.setDebug(this.a.getDebug());
            }
            context.addTipMsg("\u52a8\u4f5c" + n + "." + this.a(action.getActionType()) + "");
            action.execute(context, map);
            ++n;
        }
    }

    private String a(ActionType actionType) {
        String string = "\u672a\u77e5";
        switch (actionType) {
            case ConsolePrint: {
                string = "\u63a7\u5236\u53f0\u8f93\u51fa";
                break;
            }
            case ExecuteCommonFunction: {
                string = "\u6267\u884c\u51fd\u6570";
                break;
            }
            case ExecuteMethod: {
                string = "\u6267\u884c\u65b9\u6cd5";
                break;
            }
            case Scoring: {
                string = "\u8bc4\u5206\u5361\u5f97\u5206\u8ba1\u7b97";
                break;
            }
            case VariableAssign: {
                string = "\u53d8\u91cf\u8d4b\u503c";
                break;
            }
            case TemplateAction: {
                throw new RuleException("Unsupport action type:" + (Object)((Object)ActionType.TemplateAction));
            }
        }
        return string;
    }

    @Override
    public Rule convertToElseRule() {
        this.a = Utils.buildElseRule(this.a);
        return this.a;
    }

    public void setCriterias(Set<Criteria> set) {
        this.b = set;
    }

    public void setFactMap(Map<String, Object> map) {
        this.c = map;
    }

    @Override
    public Rule getRule() {
        return this.a;
    }

    public void setRule(Rule rule) {
        this.a = rule;
    }

    @Override
    public int compareTo(Activation activation) {
        Integer n = activation.getRule().getSalience();
        Integer n2 = this.a.getSalience();
        if (n != null && n2 != null) {
            return n - n2;
        }
        if (n != null) {
            return 1;
        }
        if (n2 != null) {
            return -1;
        }
        return 0;
    }
}

