/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.assertor;

import com.bstek.urule.Utils;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Op;
import com.bstek.urule.runtime.assertor.Assertor;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class EqualsAssertor
implements Assertor {
    @Override
    public boolean eval(Object object, Object object2, Datatype datatype) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        BigDecimal bigDecimal = null;
        BigDecimal bigDecimal2 = null;
        switch (datatype) {
            case String: {
                if (object2 instanceof String) {
                    return object.toString().equals(object2.toString());
                }
                if (object2 instanceof Number) {
                    try {
                        bigDecimal = Utils.toBigDecimal(object);
                        bigDecimal2 = Utils.toBigDecimal(object2);
                        return bigDecimal.compareTo(bigDecimal2) == 0;
                    }
                    catch (Exception exception) {
                        return object.toString().equals(object2.toString());
                    }
                }
                return object.toString().equals(object2.toString());
            }
            case Boolean: {
                return object.toString().equals(object2.toString());
            }
            case Date: {
                Date date = (Date)datatype.convert(object);
                Date date2 = (Date)datatype.convert(object2);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(date2);
                return calendar.compareTo(calendar2) == 0;
            }
            case Double: {
                bigDecimal = Utils.toBigDecimal(object);
                bigDecimal2 = Utils.toBigDecimal(object2);
                return bigDecimal.compareTo(bigDecimal2) == 0;
            }
            case Float: {
                bigDecimal = Utils.toBigDecimal(object);
                bigDecimal2 = Utils.toBigDecimal(object2);
                return bigDecimal.compareTo(bigDecimal2) == 0;
            }
            case Integer: {
                bigDecimal = Utils.toBigDecimal(object);
                bigDecimal2 = Utils.toBigDecimal(object2);
                return bigDecimal.compareTo(bigDecimal2) == 0;
            }
            case Long: {
                bigDecimal = Utils.toBigDecimal(object);
                bigDecimal2 = Utils.toBigDecimal(object2);
                return bigDecimal.compareTo(bigDecimal2) == 0;
            }
            case BigDecimal: {
                bigDecimal = Utils.toBigDecimal(object);
                bigDecimal2 = Utils.toBigDecimal(object2);
                return bigDecimal.compareTo(bigDecimal2) == 0;
            }
            case Enum: {
                Enum enum_ = (Enum)object;
                if (object2 instanceof Enum) {
                    Enum enum_2 = (Enum)object2;
                    return enum_.equals(enum_2);
                }
                Object obj = Enum.valueOf(enum_.getClass(), object2.toString());
                return enum_.equals(obj);
            }
        }
        return object2.toString().equals(object.toString());
    }

    @Override
    public Op supportOp() {
        return Op.Equals;
    }
}

