/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.cache;

import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.cache.KnowledgeCache;
import com.bstek.urule.runtime.cache.KnowledgePackageData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryKnowledgeCache
implements KnowledgeCache {
    private Map<String, KnowledgePackageData> a = new ConcurrentHashMap<String, KnowledgePackageData>();

    protected MemoryKnowledgeCache() {
    }

    @Override
    public KnowledgePackage getKnowledge(String string) {
        KnowledgePackageData knowledgePackageData;
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        if ((knowledgePackageData = this.a.get(string)) == null) {
            return null;
        }
        if (knowledgePackageData.isEnable()) {
            return knowledgePackageData.getKnowledgePackage();
        }
        throw new RuleException("Knowledge package [" + string + "] is disabled.");
    }

    @Override
    public void putKnowledge(String string, KnowledgePackage knowledgePackage) {
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        this.a.put(string, new KnowledgePackageData(knowledgePackage, true));
    }

    @Override
    public void enable(String string, boolean bl) {
        KnowledgePackageData knowledgePackageData;
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        if ((knowledgePackageData = this.a.get(string)) == null) {
            return;
        }
        knowledgePackageData.setEnable(bl);
    }

    @Override
    public void removeKnowledge(String string) {
        this.a.remove(string);
    }

    @Override
    public void clean() {
        this.a.clear();
    }
}

