/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.expr;

import com.bstek.urule.Utils;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.rule.ArithmeticType;
import com.bstek.urule.runtime.expr.ValueWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Stack;

public class ValueBuilder {
    private Stack<Object> a = new Stack();

    public ValueWrapper build() {
        ValueWrapper valueWrapper = (ValueWrapper)this.a.firstElement();
        this.a.removeElementAt(0);
        while (!this.a.isEmpty()) {
            ArithmeticType arithmeticType = (ArithmeticType)((Object)this.a.firstElement());
            this.a.removeElementAt(0);
            if (this.a.isEmpty()) {
                throw new RuleException("\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
            }
            ValueWrapper valueWrapper2 = (ValueWrapper)this.a.firstElement();
            this.a.removeElementAt(0);
            valueWrapper = this.a(valueWrapper, valueWrapper2, arithmeticType);
        }
        return valueWrapper;
    }

    private ValueWrapper a(ValueWrapper valueWrapper, ValueWrapper valueWrapper2, ArithmeticType arithmeticType) {
        BigDecimal bigDecimal = valueWrapper.getBigDecimalValue();
        BigDecimal bigDecimal2 = valueWrapper2.getBigDecimalValue();
        if (arithmeticType.equals((Object)ArithmeticType.Add) && (bigDecimal == null || bigDecimal2 == null)) {
            String string = valueWrapper.originalValueToString() + valueWrapper2.originalValueToString();
            return new ValueWrapper(string, null);
        }
        if (arithmeticType.equals((Object)ArithmeticType.Eq) && (bigDecimal == null || bigDecimal2 == null)) {
            boolean bl = valueWrapper.originalValueToString().equals(valueWrapper2.originalValueToString());
            return new ValueWrapper(bl, null);
        }
        if (arithmeticType.equals((Object)ArithmeticType.NotEq) && (bigDecimal == null || bigDecimal2 == null)) {
            boolean bl = valueWrapper.originalValueToString().equals(valueWrapper2.originalValueToString());
            return new ValueWrapper(!bl, null);
        }
        if (bigDecimal == null) {
            String string = valueWrapper.getValueId();
            if (string != null) {
                throw new RuleException("\u8868\u8fbe\u5f0f [" + string + "]\u7684\u503c[" + valueWrapper.getOriginalValue() + "] \u4e0d\u80fd\u8f6c\u6362\u4e3a\u6570\u5b57!");
            }
            throw new RuleException("\u8868\u8fbe\u5f0f [" + valueWrapper.getOriginalValue() + "] \u4e0d\u80fd\u8f6c\u6362\u4e3a\u6570\u5b57!");
        }
        if (bigDecimal2 == null) {
            String string = valueWrapper2.getValueId();
            if (string != null) {
                throw new RuleException("\u8868\u8fbe\u5f0f [" + string + "]\u7684\u503c[" + valueWrapper.getOriginalValue() + "] \u4e0d\u80fd\u8f6c\u6362\u4e3a\u6570\u5b57!");
            }
            throw new RuleException("\u8868\u8fbe\u5f0f [" + valueWrapper2.getOriginalValue() + "] \u4e0d\u80fd\u8f6c\u6362\u4e3a\u6570\u5b57!");
        }
        switch (arithmeticType) {
            case Add: {
                BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2);
                return new ValueWrapper(bigDecimal3, bigDecimal3, null);
            }
            case Div: {
                BigDecimal bigDecimal4 = bigDecimal.divide(bigDecimal2, 32, RoundingMode.HALF_UP);
                return new ValueWrapper(bigDecimal4, bigDecimal4, null);
            }
            case Mod: {
                BigDecimal bigDecimal5 = bigDecimal.divideAndRemainder(bigDecimal2)[1];
                return new ValueWrapper(bigDecimal5, bigDecimal5, null);
            }
            case Mul: {
                BigDecimal bigDecimal6 = bigDecimal.multiply(bigDecimal2);
                return new ValueWrapper(bigDecimal6, bigDecimal6, null);
            }
            case Sub: {
                BigDecimal bigDecimal7 = bigDecimal.subtract(bigDecimal2);
                return new ValueWrapper(bigDecimal7, bigDecimal7, null);
            }
            case Eq: {
                boolean bl = this.e(bigDecimal, bigDecimal2);
                return new ValueWrapper(bl, null);
            }
            case NotEq: {
                boolean bl = this.e(bigDecimal, bigDecimal2);
                return new ValueWrapper(!bl, null);
            }
            case Gt: {
                boolean bl = this.b(bigDecimal, bigDecimal2);
                return new ValueWrapper(bl, null);
            }
            case Gte: {
                boolean bl = this.a(bigDecimal, bigDecimal2);
                return new ValueWrapper(bl, null);
            }
            case Lt: {
                boolean bl = this.d(bigDecimal, bigDecimal2);
                return new ValueWrapper(bl, null);
            }
            case Lte: {
                boolean bl = this.c(bigDecimal, bigDecimal2);
                return new ValueWrapper(bl, null);
            }
        }
        throw new RuleException("Unknow operator " + (Object)((Object)arithmeticType));
    }

    private boolean a(Object object, Object object2) {
        BigDecimal bigDecimal;
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null && object2 != null) {
            return false;
        }
        if (object != null && object2 == null) {
            return false;
        }
        BigDecimal bigDecimal2 = Utils.toBigDecimal(object);
        return bigDecimal2.compareTo(bigDecimal = Utils.toBigDecimal(object2)) > -1;
    }

    private boolean b(Object object, Object object2) {
        BigDecimal bigDecimal;
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null && object2 != null) {
            return false;
        }
        if (object != null && object2 == null) {
            return false;
        }
        BigDecimal bigDecimal2 = Utils.toBigDecimal(object);
        return bigDecimal2.compareTo(bigDecimal = Utils.toBigDecimal(object2)) == 1;
    }

    private boolean c(Object object, Object object2) {
        BigDecimal bigDecimal;
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null && object2 != null) {
            return false;
        }
        if (object != null && object2 == null) {
            return false;
        }
        BigDecimal bigDecimal2 = Utils.toBigDecimal(object);
        return bigDecimal2.compareTo(bigDecimal = Utils.toBigDecimal(object2)) < 1;
    }

    private boolean d(Object object, Object object2) {
        BigDecimal bigDecimal;
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null && object2 != null) {
            return false;
        }
        if (object != null && object2 == null) {
            return false;
        }
        BigDecimal bigDecimal2 = Utils.toBigDecimal(object);
        return bigDecimal2.compareTo(bigDecimal = Utils.toBigDecimal(object2)) == -1;
    }

    private boolean e(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null && object2 != null) {
            return false;
        }
        if (object != null && object2 == null) {
            return false;
        }
        try {
            BigDecimal bigDecimal = Utils.toBigDecimal(object);
            BigDecimal bigDecimal2 = Utils.toBigDecimal(object2);
            return bigDecimal.compareTo(bigDecimal2) == 0;
        }
        catch (Exception exception) {
            return object.toString().equals(object2.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addValue(Object object) {
        block8: {
            block9: {
                if (this.a.isEmpty()) break block9;
                Object object2 = this.a.peek();
                if (object2 instanceof ValueWrapper) {
                    if (object instanceof ValueWrapper) {
                        throw new RuleException("\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
                    }
                    break block8;
                } else {
                    if (object instanceof ArithmeticType) {
                        throw new RuleException("\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
                    }
                    ArithmeticType arithmeticType = (ArithmeticType)((Object)object2);
                    if (!arithmeticType.equals((Object)ArithmeticType.Add) && !arithmeticType.equals((Object)ArithmeticType.Sub)) {
                        this.a.pop();
                        ValueWrapper valueWrapper = (ValueWrapper)this.a.pop();
                        ValueWrapper valueWrapper2 = (ValueWrapper)object;
                        object = this.a(valueWrapper, valueWrapper2, arithmeticType);
                        break block8;
                    } else if (this.a.size() <= 2) {
                        // empty if block
                    }
                }
                break block8;
            }
            if (object instanceof ArithmeticType) {
                throw new RuleException("\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
            }
        }
        this.a.push(object);
    }
}

