/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.monitor;

import com.bstek.urule.Utils;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.FactManager;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.log.LogManager;
import com.bstek.urule.runtime.monitor.IOData;
import com.bstek.urule.runtime.monitor.IODataField;
import com.bstek.urule.runtime.monitor.InvokeMonitor;
import com.bstek.urule.runtime.monitor.MonitorDataImpl;
import com.bstek.urule.runtime.monitor.MonitorObject;
import com.bstek.urule.runtime.monitor.MonitorObjectField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonitorManager {
    private LogManager a;
    private long b;
    private FactManager c;
    private Collection<InvokeMonitor> d;
    private Map<String, MonitorDataImpl> e = new HashMap<String, MonitorDataImpl>();
    private List<KnowledgePackage> f;

    public MonitorManager(KnowledgeSession knowledgeSession) {
        this.a = knowledgeSession.getLogManager();
        this.c = knowledgeSession.getFactManager();
        this.f = knowledgeSession.getKnowledgePackageList();
        this.d = Utils.getApplicationContext().getBeansOfType(InvokeMonitor.class).values();
    }

    public void doMonitorInputData(Map<String, Object> map) {
        if (this.d.size() == 0) {
            return;
        }
        for (KnowledgePackage knowledgePackage : this.f) {
            if (!knowledgePackage.isMonitor()) continue;
            MonitorDataImpl monitorDataImpl = new MonitorDataImpl();
            monitorDataImpl.setPackageInfo(knowledgePackage.getPackageInfo());
            List<MonitorObject> list = knowledgePackage.getInputData();
            List<IOData> list2 = this.a(list, knowledgePackage.getVariableCateogoryMap(), map, true);
            monitorDataImpl.setInputData(list2);
            this.e.put(knowledgePackage.getId(), monitorDataImpl);
        }
    }

    public void doMonitor(Map<String, Object> map) {
        if (this.d.size() == 0) {
            return;
        }
        for (KnowledgePackage knowledgePackage : this.f) {
            if (!knowledgePackage.isMonitor()) continue;
            MonitorDataImpl monitorDataImpl = this.e.get(knowledgePackage.getId());
            monitorDataImpl.addMatchedRuleList(this.a.buildMatchedRuleLog());
            monitorDataImpl.addNotMatchRuleList(this.a.buildNotMatchRuleData());
            monitorDataImpl.addLogs(this.a.getLogger().getLogs());
            monitorDataImpl.setVersion(knowledgePackage.getVersion());
            List<MonitorObject> list = knowledgePackage.getOutputData();
            List<IOData> list2 = this.a(list, knowledgePackage.getVariableCateogoryMap(), map, false);
            monitorDataImpl.setOutputData(list2);
            monitorDataImpl.setTotalDuration(this.b);
            for (InvokeMonitor invokeMonitor : this.d) {
                invokeMonitor.doMonitor(monitorDataImpl);
            }
        }
        this.e.clear();
    }

    private List<IOData> a(List<MonitorObject> list, Map<String, String> map, Map<String, Object> map2, boolean bl) {
        ArrayList<IOData> arrayList = new ArrayList<IOData>();
        Map<String, Object> map3 = this.c.getFactMap();
        for (MonitorObject monitorObject : list) {
            Object object = null;
            String string = null;
            if (monitorObject.getName().equals("\u53c2\u6570")) {
                object = map2;
                string = HashMap.class.getName();
            } else {
                string = map.get(monitorObject.getName());
                if (string == null) {
                    if (bl) {
                        throw new RuleException("\u6784\u5efa\u76d1\u63a7\u8f93\u5165\u6570\u636e\u65f6\uff0c\u5bf9\u8c61[" + monitorObject.getName() + "]\u4e0d\u5b58\u5728\uff01");
                    }
                    throw new RuleException("\u6784\u5efa\u76d1\u63a7\u8f93\u51fa\u6570\u636e\u65f6\uff0c\u5bf9\u8c61[" + monitorObject.getName() + "]\u4e0d\u5b58\u5728\uff01");
                }
                object = map3.get(string);
                if (object == null) {
                    if (bl) {
                        throw new RuleException("\u6784\u5efa\u76d1\u63a7\u8f93\u5165\u6570\u636e\u65f6\uff0c\u5bf9\u8c61[" + string + "]\u4e0d\u5b58\u5728\uff01");
                    }
                    throw new RuleException("\u6784\u5efa\u76d1\u63a7\u8f93\u51fa\u6570\u636e\u65f6\uff0c\u5bf9\u8c61[" + string + "]\u4e0d\u5b58\u5728\uff01");
                }
            }
            IOData iOData = new IOData();
            arrayList.add(iOData);
            iOData.setName(monitorObject.getName());
            iOData.setClazz(string);
            ArrayList<IODataField> arrayList2 = new ArrayList<IODataField>();
            iOData.setFields(arrayList2);
            for (MonitorObjectField monitorObjectField : monitorObject.getFields()) {
                IODataField iODataField = new IODataField();
                String string2 = monitorObjectField.getName();
                Object object2 = Utils.getObjectProperty(object, string2);
                iODataField.setName(string2);
                iODataField.setLabel(monitorObjectField.getLabel());
                iODataField.setValue(object2);
                arrayList2.add(iODataField);
            }
        }
        return arrayList;
    }

    public void setTotalDuration(long l) {
        this.b = l;
    }
}

