/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.runtime.rete;

import com.bstek.urule.Utils;
import com.bstek.urule.model.rete.RuleData;
import com.bstek.urule.runtime.WorkingMemory;
import com.bstek.urule.runtime.assertor.AssertorEvaluator;
import com.bstek.urule.runtime.log.Logger;
import com.bstek.urule.runtime.rete.Context;
import com.bstek.urule.runtime.rete.ExecutionContext;
import com.bstek.urule.runtime.rete.ExecutionContextImpl;
import com.bstek.urule.runtime.rete.ValueCompute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;

public class ContextImpl
extends ExecutionContextImpl
implements Context,
ExecutionContext {
    private ValueCompute valueCompute;
    private WorkingMemory workingMemory;
    private List<RuleData> ruleDataList;
    private AssertorEvaluator assertorEvaluator;
    private ApplicationContext applicationContext;
    private Map<String, String> variableCategoryMap;
    private boolean parentIsObjectInstanceMethod;
    private StringBuilder tipMsgBuilder = new StringBuilder();

    public ContextImpl(WorkingMemory workingMemory, Map<String, String> map) {
        this.workingMemory = workingMemory;
        this.applicationContext = Utils.getApplicationContext();
        this.assertorEvaluator = (AssertorEvaluator)this.applicationContext.getBean("urule.assertorEvaluator");
        this.variableCategoryMap = map;
        this.valueCompute = (ValueCompute)this.applicationContext.getBean("urule.valueCompute");
        this.ruleDataList = workingMemory.getLogManager().getRuleData();
    }

    @Override
    public void addTipMsg(String string) {
        if (this.tipMsgBuilder.length() > 0) {
            this.tipMsgBuilder.append(">>");
        }
        this.tipMsgBuilder.append(string);
    }

    @Override
    public void cleanTipMsg() {
        this.tipMsgBuilder.delete(0, this.tipMsgBuilder.length());
    }

    @Override
    public String getTipMsg() {
        if (this.tipMsgBuilder.length() > 0) {
            return this.tipMsgBuilder.toString();
        }
        return null;
    }

    @Override
    public AssertorEvaluator getAssertorEvaluator() {
        return this.assertorEvaluator;
    }

    @Override
    public Logger getLogger() {
        return this.getWorkingMemory().getLogManager().getLogger();
    }

    @Override
    public String getVariableCategoryClass(String string) {
        String string2 = this.variableCategoryMap.get(string);
        if (StringUtils.isEmpty((String)string2)) {
            string2 = HashMap.class.getName();
        }
        return string2;
    }

    @Override
    public synchronized void addRuleData(List<RuleData> list) {
        this.ruleDataList.addAll(list);
    }

    @Override
    public ValueCompute getValueCompute() {
        return this.valueCompute;
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void resetParentIsObjectInstanceMethod(boolean bl) {
        this.parentIsObjectInstanceMethod = bl;
    }

    @Override
    public boolean parentIsObjectInstanceMethod() {
        return this.parentIsObjectInstanceMethod;
    }
}

