/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.crx;

import com.btmatthews.maven.plugins.crx.ArchiveHelper;
import com.btmatthews.maven.plugins.crx.CRXArchive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ArchiveHelper.class, hint="crx")
public class CRXArchiveHelper
implements ArchiveHelper {
    private static final int BYTE_MASK = 255;
    private static final int SHIFT_8 = 8;
    private static final int SHIFT_16 = 16;
    private static final int SHIFT_24 = 24;
    private static final byte[] CRX_MAGIC = new byte[]{67, 114, 50, 52};
    private static final byte[] CRX_VERSION = new byte[]{2, 0, 0, 0};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeArchive(File crxFile, CRXArchive crxArchive) throws IOException {
        if (crxFile.exists()) {
            crxFile.delete();
        } else {
            crxFile.getParentFile().mkdirs();
        }
        FileOutputStream crx = new FileOutputStream(crxFile);
        try {
            crx.write(CRX_MAGIC);
            crx.write(CRX_VERSION);
            this.writeLength(crx, crxArchive.getPublicKey().length);
            this.writeLength(crx, crxArchive.getSignature().length);
            crx.write(crxArchive.getPublicKey());
            crx.write(crxArchive.getSignature());
            crx.write(crxArchive.getData());
        }
        finally {
            crx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRXArchive readArchive(File crxFile) throws IOException {
        byte[] buffer = new byte[4];
        FileInputStream crxIn = new FileInputStream(crxFile);
        try {
            ((InputStream)crxIn).read(buffer);
            ((InputStream)crxIn).read(buffer);
            int publicKeyLength = this.readLength(crxIn);
            int signatureLength = this.readLength(crxIn);
            byte[] publicKey = new byte[publicKeyLength];
            ((InputStream)crxIn).read(publicKey);
            byte[] signature = new byte[signatureLength];
            ((InputStream)crxIn).read(signature);
            int dataLength = (int)(crxFile.length() - 16L - (long)publicKeyLength - (long)signatureLength);
            byte[] data = new byte[dataLength];
            ((InputStream)crxIn).read(data);
            CRXArchive cRXArchive = new CRXArchive(publicKey, signature, data);
            return cRXArchive;
        }
        finally {
            ((InputStream)crxIn).close();
        }
    }

    private void writeLength(OutputStream out, int val) throws IOException {
        out.write(val & 0xFF);
        out.write(val >> 8 & 0xFF);
        out.write(val >> 16 & 0xFF);
        out.write(val >> 24 & 0xFF);
    }

    private int readLength(InputStream in) throws IOException {
        byte[] buffer = new byte[4];
        in.read(buffer, 0, 4);
        return buffer[3] << 24 | (buffer[2] & 0xFF) << 16 | (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
    }
}

