/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.crx;

import com.btmatthews.maven.plugins.crx.ArchiveHelper;
import com.btmatthews.maven.plugins.crx.CRXArchive;
import com.btmatthews.maven.plugins.crx.CRXArchiver;
import com.btmatthews.maven.plugins.crx.SignatureHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.bc.BcPEMDecryptorProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.zip.AbstractZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipOutputStream;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=CRXArchiver.class, hint="crx", instantiationStrategy="per-lookup")
public class CRXArchiverImpl
extends AbstractZipArchiver
implements CRXArchiver {
    private File pemFile;
    private String pemPassword;
    @Requirement(hint="crx")
    private SignatureHelper signatureHelper;
    @Requirement(hint="crx")
    private ArchiveHelper archiveHelper;

    public void setPemFile(File file) {
        this.pemFile = file;
    }

    public final void setPemPassword(String password) {
        this.pemPassword = password;
    }

    public void setSignatureHelper(SignatureHelper helper) {
        this.signatureHelper = helper;
    }

    public void setArchiveHelper(ArchiveHelper helper) {
        this.archiveHelper = helper;
    }

    protected String getArchiveType() {
        return "crx";
    }

    protected void execute() {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            byte[] zipData = this.createZipFile();
            KeyPair keyPair = this.getKeyPair();
            byte[] publicKey = keyPair.getPublic().getEncoded();
            byte[] signature = this.signatureHelper.sign(zipData, keyPair.getPrivate());
            CRXArchive archive = new CRXArchive(publicKey, signature, zipData);
            this.archiveHelper.writeArchive(this.getDestFile(), archive);
        }
        catch (GeneralSecurityException e) {
            throw new ArchiverException("Could not generate the signature for the CRX file", (Throwable)e);
        }
        catch (IOException e) {
            throw new ArchiverException("Could not read resources or output the CRX file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private KeyPair getKeyPair() {
        try {
            FileReader pemFileReader = new FileReader(this.pemFile);
            try {
                Object pemObject;
                PEMParser pemParser;
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                KeyPair keyPair;
                                pemParser = new PEMParser((Reader)pemFileReader);
                                try {
                                    pemObject = pemParser.readObject();
                                    if (!(pemObject instanceof KeyPair)) break block19;
                                    keyPair = (KeyPair)pemObject;
                                }
                                catch (Throwable throwable) {
                                    pemParser.close();
                                    throw throwable;
                                }
                                pemParser.close();
                                return keyPair;
                            }
                            if (!(pemObject instanceof PEMKeyPair)) break block20;
                            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                            KeyPair keyPair = converter.getKeyPair((PEMKeyPair)pemObject);
                            pemParser.close();
                            return keyPair;
                        }
                        if (!(pemObject instanceof PEMEncryptedKeyPair)) break block21;
                        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                        PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)pemObject;
                        BcPEMDecryptorProvider decryptorProvider = new BcPEMDecryptorProvider(this.pemPassword.toCharArray());
                        PEMKeyPair pemKeyPair = encryptedKeyPair.decryptKeyPair((PEMDecryptorProvider)decryptorProvider);
                        KeyPair keyPair = converter.getKeyPair(pemKeyPair);
                        pemParser.close();
                        return keyPair;
                    }
                    if (!(pemObject instanceof PrivateKeyInfo)) break block22;
                    JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                    PrivateKey privateKey = converter.getPrivateKey((PrivateKeyInfo)pemObject);
                    KeyPair keyPair = this.convertRSAPrivateCrtKey(privateKey);
                    pemParser.close();
                    return keyPair;
                }
                KeyPair keyPair = this.convertRSAPrivateCrtKey(pemObject);
                pemParser.close();
                return keyPair;
            }
            finally {
                ((Reader)pemFileReader).close();
            }
        }
        catch (InvalidKeySpecException e) {
            throw new ArchiverException("Cannot generate RSA public key", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ArchiverException("RSA Private key algorithm is not supported", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            throw new ArchiverException("Bouncy Castle not registered correctly", (Throwable)e);
        }
        catch (IOException e) {
            throw new ArchiverException("Could not load the public/private key from the PEM file", (Throwable)e);
        }
    }

    private KeyPair convertRSAPrivateCrtKey(Object pemObject) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        if (pemObject instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey privateCrtKey = (RSAPrivateCrtKey)pemObject;
            BigInteger exponent = privateCrtKey.getPublicExponent();
            BigInteger modulus = privateCrtKey.getModulus();
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            return new KeyPair(publicKey, privateCrtKey);
        }
        throw new ArchiverException("Could not load the public/private key from invalid PEM file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createZipFile() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream((OutputStream)buffer);
        try {
            out.setMethod(8);
            out.setLevel(9);
            ResourceIterator resourceIterator = this.getResources();
            this.addResources(resourceIterator, out);
        }
        finally {
            out.close();
        }
        return buffer.toByteArray();
    }
}

