/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.crx;

import com.btmatthews.maven.plugins.crx.CRXArchiver;
import com.btmatthews.maven.plugins.crx.ParameterUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="crx", defaultPhase=LifecyclePhase.PACKAGE)
public class CRXMojo
extends AbstractMojo {
    @Parameter(defaultValue="${crxPEMFile}", required=true)
    private File pemFile;
    @Parameter(defaultValue="${crxPEMPassword}")
    private String pemPassword;
    @Parameter(defaultValue="${basedir}/src/main/chrome", required=true)
    private File crxSourceDirectory;
    @Parameter(required=false)
    private String packagingIncludes;
    @Parameter(required=false)
    private String packagingExcludes;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="false")
    private boolean filtering;
    @Parameter
    private List filters;
    @Parameter
    private List nonFilteredFileExtensions;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Component(role=CRXArchiver.class, hint="crx")
    private CRXArchiver crxArchiver;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    private MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    private List filterWrappers;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        File manifestFile = new File(this.crxSourceDirectory, "manifest.json");
        if (!manifestFile.exists()) {
            throw new MojoExecutionException("Missing manifest.json file");
        }
        StringBuilder crxFilename = new StringBuilder();
        crxFilename.append(this.finalName);
        if (StringUtils.isNotEmpty((String)this.classifier)) {
            crxFilename.append('-');
            crxFilename.append(this.classifier);
        }
        File crxDirectory = new File(this.outputDirectory, crxFilename.toString());
        crxFilename.append(".crx");
        this.copyFiles(this.crxSourceDirectory, crxDirectory);
        File crxFile = new File(this.outputDirectory, crxFilename.toString());
        String[] includes = ParameterUtils.splitParameter(this.packagingIncludes);
        String[] excludes = ParameterUtils.splitParameter(this.packagingExcludes);
        this.crxArchiver.setPemFile(this.pemFile);
        this.crxArchiver.setPemPassword(this.pemPassword);
        this.crxArchiver.addDirectory(crxDirectory, includes, excludes);
        this.crxArchiver.setDestFile(crxFile);
        try {
            this.crxArchiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to package and sign the Google Chrome Extension", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (StringUtils.isNotEmpty((String)this.classifier)) {
            this.projectHelper.attachArtifact(this.project, "crx", this.classifier, crxFile);
        } else {
            this.project.getArtifact().setFile(crxFile);
        }
    }

    private void copyFiles(File source, File destination) throws MojoExecutionException {
        try {
            if (!destination.exists() && !destination.mkdirs()) {
                throw new MojoExecutionException("Could not create directory: " + destination.getAbsolutePath());
            }
            for (File sourceItem : source.listFiles()) {
                File destinationItem = new File(destination, sourceItem.getName());
                if (sourceItem.isDirectory()) {
                    this.copyFiles(sourceItem, destinationItem);
                    continue;
                }
                if (this.filtering && !this.isNonFilteredExtension(sourceItem.getName())) {
                    this.mavenFileFilter.copyFile(sourceItem, destinationItem, true, this.getFilterWrappers(), null);
                    continue;
                }
                FileUtils.copyFile((File)sourceItem, (File)destinationItem);
            }
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Failed to build filtering wrappers", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying file: " + source.getAbsolutePath(), (Exception)e);
        }
    }

    private boolean isNonFilteredExtension(String fileName) throws MojoExecutionException {
        return !this.mavenResourcesFiltering.filteredFileExtension(fileName, this.nonFilteredFileExtensions);
    }

    private List getFilterWrappers() throws MojoExecutionException {
        if (this.filterWrappers == null) {
            try {
                MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
                mavenResourcesExecution.setEscapeString("\\");
                this.filterWrappers = this.mavenFileFilter.getDefaultFilterWrappers(this.project, this.filters, true, this.session, mavenResourcesExecution);
            }
            catch (MavenFilteringException e) {
                throw new MojoExecutionException("Failed to build filtering wrappers: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        return this.filterWrappers;
    }
}

