/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.crx;

import com.btmatthews.maven.plugins.crx.SignatureHelper;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=SignatureHelper.class, hint="crx")
public class CRXSignatureHelper
implements SignatureHelper {
    private static final String ALGORITHM = "SHA1withRSA";

    public byte[] sign(byte[] data, PrivateKey key) throws GeneralSecurityException {
        Signature signatureObject = Signature.getInstance(ALGORITHM);
        signatureObject.initSign(key);
        signatureObject.update(data);
        return signatureObject.sign();
    }

    public boolean check(byte[] data, PublicKey key, byte[] signature) throws GeneralSecurityException {
        Signature signatureObject = Signature.getInstance(ALGORITHM);
        signatureObject.initVerify(key);
        signatureObject.update(data);
        return signatureObject.verify(signature);
    }
}

