/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.ExecutionStrategy;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import java.util.Objects;
import java.util.Optional;

public class ClientSideConfig {
    private static ClientSideConfig defaultConfig = new ClientSideConfig(Versions.getLatest(), Optional.empty(), ExecutionStrategy.SAME_TREAD);
    private final Version backwardCompatibilityVersion;
    private final Optional<TimeMeter> clientSideClock;
    private final ExecutionStrategy executionStrategy;

    protected ClientSideConfig(Version backwardCompatibilityVersion, Optional<TimeMeter> clientSideClock, ExecutionStrategy executionStrategy) {
        this.backwardCompatibilityVersion = Objects.requireNonNull(backwardCompatibilityVersion);
        this.clientSideClock = Objects.requireNonNull(clientSideClock);
        this.executionStrategy = executionStrategy;
    }

    public static ClientSideConfig getDefault() {
        return defaultConfig;
    }

    public ClientSideConfig backwardCompatibleWith(Version backwardCompatibilityVersion) {
        return new ClientSideConfig(backwardCompatibilityVersion, this.clientSideClock, this.executionStrategy);
    }

    public ClientSideConfig withClientClock(TimeMeter clientClock) {
        return new ClientSideConfig(this.backwardCompatibilityVersion, Optional.of(clientClock), this.executionStrategy);
    }

    public ClientSideConfig withExecutionStrategy(ExecutionStrategy executionStrategy) {
        return new ClientSideConfig(this.backwardCompatibilityVersion, this.clientSideClock, executionStrategy);
    }

    public Optional<TimeMeter> getClientSideClock() {
        return this.clientSideClock;
    }

    public Version getBackwardCompatibilityVersion() {
        return this.backwardCompatibilityVersion;
    }

    public ExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }
}

