/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerContext;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.report.api.model.Column;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.api.model.Row;
import com.buschmais.jqassistant.core.report.api.model.Suppress;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.xo.api.Query;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCypherRuleInterpreterPlugin
implements RuleInterpreterPlugin {
    private static final Logger log = LoggerFactory.getLogger(AbstractCypherRuleInterpreterPlugin.class);

    protected <T extends ExecutableRule<?>> Result<T> execute(String cypher, T executableRule, Map<String, Object> parameters, Severity severity, AnalyzerContext context) throws RuleException {
        Result result;
        block8: {
            log.debug("Executing query '" + cypher + "' with parameters [" + parameters + "]");
            Query.Result compositeRowObjects = context.getStore().executeQuery(cypher, parameters);
            try {
                result = (Result)context.getStore().requireTransaction(() -> this.getResult(executableRule, severity, context, (Query.Result<Query.Result.CompositeRowObject>)compositeRowObjects));
                if (compositeRowObjects == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (compositeRowObjects != null) {
                        try {
                            compositeRowObjects.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuleException("Cannot execute query for rule '" + executableRule + "'.", (Throwable)e);
                }
            }
            compositeRowObjects.close();
        }
        return result;
    }

    private <T extends ExecutableRule<?>> Result<T> getResult(T executableRule, Severity severity, AnalyzerContext context, Query.Result<Query.Result.CompositeRowObject> compositeRowObjects) throws RuleException {
        LinkedList<Row> rows = new LinkedList<Row>();
        String primaryColumn = null;
        List columnNames = null;
        for (Query.Result.CompositeRowObject rowObject : compositeRowObjects) {
            if (columnNames == null) {
                columnNames = Collections.unmodifiableList(rowObject.getColumns());
                primaryColumn = executableRule.getReport().getPrimaryColumn();
                if (primaryColumn == null) {
                    primaryColumn = (String)columnNames.get(0);
                }
            }
            LinkedHashMap columns = new LinkedHashMap();
            for (String columnName : columnNames) {
                Object value = rowObject.get(columnName, Object.class);
                columns.put(columnName, context.toColumn(value));
            }
            if (this.isSuppressedRow(executableRule.getId(), columns, primaryColumn)) continue;
            rows.add(context.toRow(executableRule, columns));
        }
        Result.Status status = this.getStatus(executableRule, severity, columnNames, rows, context);
        return Result.builder().rule(executableRule).status(status).severity(severity).columnNames(columnNames).rows(rows).build();
    }

    private boolean isSuppressedRow(String ruleId, Map<String, Column<?>> columns, String primaryColumn) {
        Object value;
        Column<?> column = columns.get(primaryColumn);
        if (column != null && (value = column.getValue()) != null && Suppress.class.isAssignableFrom(value.getClass())) {
            Suppress suppress = (Suppress)value;
            for (String suppressId : suppress.getSuppressIds()) {
                if (!ruleId.equals(suppressId)) continue;
                return true;
            }
        }
        return false;
    }

    protected <T extends ExecutableRule<?>> Result.Status getStatus(T executableRule, Severity severity, List<String> columnNames, List<Row> rows, AnalyzerContext context) throws RuleException {
        return context.verify(executableRule, severity, columnNames, rows);
    }
}

