/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.impl.AggregationVerificationStrategy;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.configuration.Report;
import com.buschmais.jqassistant.core.report.api.model.Column;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.api.model.Row;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.api.reader.AggregationVerification;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class AggregationVerificationStrategyTest {
    static final List<String> COLUMN_NAMES = Arrays.asList("c0", "c1");
    @Mock
    private Report configuration;
    @Mock
    private Concept concept;
    @Mock
    private Constraint constraint;
    private List<Row> result;
    private AggregationVerificationStrategy strategy;

    AggregationVerificationStrategyTest() {
    }

    @BeforeEach
    void setUp() {
        ((Report)Mockito.doReturn((Object)Severity.MINOR).when((Object)this.configuration)).warnOnSeverity();
        ((Report)Mockito.doReturn((Object)Severity.MAJOR).when((Object)this.configuration)).failOnSeverity();
        this.strategy = new AggregationVerificationStrategy(this.configuration);
    }

    @Test
    void defaultConcept() throws RuleException {
        AggregationVerification aggregationVerification = AggregationVerification.builder().build();
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 0), this.createRow((ExecutableRule<?>)this.concept, 0));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 0), this.createRow((ExecutableRule<?>)this.concept, 1));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 1), this.createRow((ExecutableRule<?>)this.concept, 1));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
    }

    @Test
    void min() throws RuleException {
        AggregationVerification aggregationVerification = AggregationVerification.builder().min(Integer.valueOf(1)).build();
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 0), this.createRow((ExecutableRule<?>)this.concept, 0));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 0), this.createRow((ExecutableRule<?>)this.concept, 1));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 1), this.createRow((ExecutableRule<?>)this.concept, 1));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
    }

    @Test
    void max() throws RuleException {
        AggregationVerification aggregationVerification = AggregationVerification.builder().max(Integer.valueOf(0)).build();
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 0), this.createRow((ExecutableRule<?>)this.concept, 0));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 0), this.createRow((ExecutableRule<?>)this.concept, 1));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 1), this.createRow((ExecutableRule<?>)this.concept, 1));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
    }

    @Test
    void minMax() throws RuleException {
        AggregationVerification aggregationVerification = AggregationVerification.builder().min(Integer.valueOf(1)).max(Integer.valueOf(1)).build();
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 0), this.createRow((ExecutableRule<?>)this.concept, 0));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 0), this.createRow((ExecutableRule<?>)this.concept, 1));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 1), this.createRow((ExecutableRule<?>)this.concept, 1));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 1), this.createRow((ExecutableRule<?>)this.concept, 2));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 2), this.createRow((ExecutableRule<?>)this.concept, 2));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
    }

    @Test
    void colum() throws RuleException {
        AggregationVerification aggregationVerification = AggregationVerification.builder().column("c1").build();
        this.result = Arrays.asList(this.createRow((ExecutableRule<?>)this.concept, 0, 1), this.createRow((ExecutableRule<?>)this.concept, 0, 1));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
    }

    @Test
    void emptyResult() throws RuleException {
        AggregationVerification aggregationVerification = AggregationVerification.builder().build();
        this.result = Collections.emptyList();
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, aggregationVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
    }

    private Row createRow(ExecutableRule<?> rule, int ... values) {
        LinkedHashMap<CallSite, Column> columns = new LinkedHashMap<CallSite, Column>();
        for (int i = 0; i < values.length; ++i) {
            columns.put((CallSite)((Object)("c" + i)), ReportHelper.toColumn((Object)values[i]));
        }
        return ReportHelper.toRow(rule, columns);
    }
}

