/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerContext;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.analysis.api.configuration.Analyze;
import com.buschmais.jqassistant.core.analysis.api.model.ConceptDescriptor;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerRuleVisitor;
import com.buschmais.jqassistant.core.analysis.impl.CypherRuleInterpreterPlugin;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.api.model.Row;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.CypherExecutable;
import com.buschmais.jqassistant.core.rule.api.model.Executable;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Parameter;
import com.buschmais.jqassistant.core.rule.api.model.Report;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.api.model.Verification;
import com.buschmais.jqassistant.core.rule.api.reader.RowCountVerification;
import com.buschmais.jqassistant.core.rule.api.source.FileRuleSource;
import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import com.buschmais.jqassistant.core.shared.transaction.Transactional;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.xo.api.Query;
import com.buschmais.xo.api.ResultIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@MockitoSettings(strictness=Strictness.LENIENT)
@ExtendWith(value={MockitoExtension.class})
class AnalyzerRuleVisitorTest {
    private static final FileRuleSource FILE_RULE_SOURCE = new FileRuleSource(new File("."), "test.xml");
    private static final String STATEMENT = "match (n) return n";
    private static final String PARAMETER_WITHOUT_DEFAULT = "noDefault";
    private static final String PARAMETER_WITH_DEFAULT = "withDefault";
    private static final RowCountVerification ROW_COUNT_VERIFICATION = RowCountVerification.builder().build();
    @Mock
    private Store store;
    @Mock
    private ReportPlugin reportWriter;
    @Mock
    private Analyze configuration;
    @Mock
    private AnalyzerContext analyzerContext;
    private Map<String, Collection<RuleInterpreterPlugin>> ruleInterpreterPlugins = new HashMap<String, Collection<RuleInterpreterPlugin>>();
    private AnalyzerRuleVisitor analyzerRuleVisitor;
    private Concept concept;
    private Constraint constraint;
    private List<String> columnNames;

    AnalyzerRuleVisitorTest() {
    }

    @BeforeEach
    void setUp() {
        this.concept = this.createConcept("test:Concept");
        this.constraint = this.createConstraint(STATEMENT);
        this.columnNames = Arrays.asList("c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9");
        HashMap<String, String> ruleParameters = new HashMap<String, String>();
        ruleParameters.put(PARAMETER_WITHOUT_DEFAULT, "value");
        ((Analyze)Mockito.doReturn(ruleParameters).when((Object)this.configuration)).ruleParameters();
        ((Store)Mockito.doReturn(this.createResult(this.columnNames)).when((Object)this.store)).executeQuery((String)ArgumentMatchers.eq((Object)STATEMENT), Mockito.anyMap());
        ((AnalyzerContext)Mockito.doReturn((Object)this.store).when((Object)this.analyzerContext)).getStore();
        ((Store)Mockito.doAnswer(invocation -> {
            ((Transactional.TransactionalAction)invocation.getArgument(0)).execute();
            return null;
        }).when((Object)this.store)).requireTransaction((Transactional.TransactionalAction)Mockito.any(Transactional.TransactionalAction.class));
        ((Store)Mockito.doAnswer(invocation -> ((Transactional.TransactionalSupplier)invocation.getArgument(0)).execute()).when((Object)this.store)).requireTransaction((Transactional.TransactionalSupplier)Mockito.any(Transactional.TransactionalSupplier.class));
        Mockito.when((Object)((ConceptDescriptor)this.store.create(ConceptDescriptor.class))).thenReturn((Object)((ConceptDescriptor)Mockito.mock(ConceptDescriptor.class)));
        ArrayList<CypherRuleInterpreterPlugin> languagePlugins = new ArrayList<CypherRuleInterpreterPlugin>();
        languagePlugins.add(new CypherRuleInterpreterPlugin());
        this.ruleInterpreterPlugins.put("cypher", languagePlugins);
        this.analyzerRuleVisitor = new AnalyzerRuleVisitor(this.configuration, this.analyzerContext, this.ruleInterpreterPlugins, this.reportWriter);
    }

    @Test
    void columnOrder() throws RuleException {
        ((AnalyzerContext)Mockito.doAnswer(i -> {
            Object value = i.getArgument(0);
            return ReportHelper.toColumn((Object)value);
        }).when((Object)this.analyzerContext)).toColumn(Mockito.any());
        ((AnalyzerContext)Mockito.doAnswer(i -> {
            ExecutableRule rule = (ExecutableRule)i.getArgument(0);
            Map columns = (Map)i.getArgument(1);
            return ReportHelper.toRow((ExecutableRule)rule, (Map)columns);
        }).when((Object)this.analyzerContext)).toRow((ExecutableRule)Mockito.any(ExecutableRule.class), Mockito.anyMap());
        this.analyzerRuleVisitor.visitConcept(this.concept, Severity.MINOR, Collections.emptyMap());
        ArgumentCaptor resultCaptor = ArgumentCaptor.forClass(Result.class);
        ((ReportPlugin)Mockito.verify((Object)this.reportWriter)).setResult((Result)resultCaptor.capture());
        ((AnalyzerContext)Mockito.verify((Object)this.analyzerContext)).toRow((ExecutableRule)Mockito.any(ExecutableRule.class), Mockito.anyMap());
        Result capturedResult = (Result)resultCaptor.getValue();
        MatcherAssert.assertThat((String)"The reported column names must match the given column names.", (Object)capturedResult.getColumnNames(), (Matcher)CoreMatchers.equalTo(this.columnNames));
        List capturedRows = capturedResult.getRows();
        MatcherAssert.assertThat((String)"Expecting one row.", (Object)capturedRows.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Row capturedRow = (Row)capturedRows.get(0);
        MatcherAssert.assertThat((String)"The reported column names must match the given column names.", new ArrayList(capturedRow.getColumns().keySet()), (Matcher)CoreMatchers.equalTo(this.columnNames));
    }

    @Test
    void executeConcept() throws RuleException {
        ((AnalyzerContext)Mockito.doReturn((Object)Result.Status.SUCCESS).when((Object)this.analyzerContext)).verify((ExecutableRule)((Concept)ArgumentMatchers.eq((Object)this.concept)), (Severity)ArgumentMatchers.eq((Object)Severity.MAJOR), ArgumentMatchers.anyList(), ArgumentMatchers.anyList());
        Result.Status status = this.analyzerRuleVisitor.visitConcept(this.concept, Severity.MAJOR, Collections.emptyMap());
        MatcherAssert.assertThat((Object)status, (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Map.class);
        ((Store)Mockito.verify((Object)this.store)).executeQuery((String)ArgumentMatchers.eq((Object)STATEMENT), (Map)argumentCaptor.capture());
        Map parameters = (Map)argumentCaptor.getValue();
        MatcherAssert.assertThat(parameters.get(PARAMETER_WITHOUT_DEFAULT), (Matcher)CoreMatchers.equalTo((Object)"value"));
        MatcherAssert.assertThat(parameters.get(PARAMETER_WITH_DEFAULT), (Matcher)CoreMatchers.equalTo((Object)"defaultValue"));
        this.verifyConceptResult(this.concept, Result.Status.SUCCESS, Severity.MAJOR);
        ((Store)Mockito.verify((Object)this.store)).create(ConceptDescriptor.class);
    }

    @Test
    void abstractConcept() throws RuleException {
        Concept abstractConcept = this.createConcept("test:AbstractConcept", null);
        Result.Status status = this.analyzerRuleVisitor.visitConcept(abstractConcept, Severity.MAJOR, Collections.emptyMap());
        MatcherAssert.assertThat((Object)status, (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        ((Store)Mockito.verify((Object)this.store, (VerificationMode)Mockito.never())).executeQuery(Mockito.anyString(), Mockito.anyMap());
        Result<Concept> result = this.verifyConceptResult(abstractConcept, Result.Status.SUCCESS, Severity.MAJOR);
        MatcherAssert.assertThat((Object)result.getColumnNames(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)result.getRows(), (Matcher)Matchers.empty());
        ((Store)Mockito.verify((Object)this.store)).create(ConceptDescriptor.class);
    }

    @Test
    void providedConcepts() throws RuleException {
        Concept providingConcept1 = this.createConcept("test:ProvidingConcept1");
        Concept providingConcept2 = this.createConcept("test:ProvidingConcept2");
        Concept providedConcept = this.createConcept("test:ProvidedConcept");
        ((Store)Mockito.doReturn(this.createEmptyResult()).when((Object)this.store)).executeQuery((String)ArgumentMatchers.eq((Object)STATEMENT), Mockito.anyMap());
        MatcherAssert.assertThat((Object)this.analyzerRuleVisitor.visitConcept(providedConcept, Severity.MAJOR, Map.ofEntries(Map.entry(providingConcept1, Result.Status.FAILURE), Map.entry(providingConcept2, Result.Status.FAILURE))), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
        MatcherAssert.assertThat((Object)this.analyzerRuleVisitor.visitConcept(providedConcept, Severity.MAJOR, Map.ofEntries(Map.entry(providingConcept1, Result.Status.FAILURE), Map.entry(providingConcept2, Result.Status.SUCCESS))), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)this.analyzerRuleVisitor.visitConcept(providedConcept, Severity.MAJOR, Map.ofEntries(Map.entry(providingConcept1, Result.Status.SUCCESS), Map.entry(providingConcept2, Result.Status.SUCCESS))), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
    }

    @Test
    void skipConcept() throws RuleException {
        this.analyzerRuleVisitor.skipConcept(this.concept, Severity.MAJOR);
        ((Store)Mockito.verify((Object)this.store, (VerificationMode)Mockito.never())).executeQuery((String)ArgumentMatchers.eq((Object)STATEMENT), Mockito.anyMap());
        this.verifyConceptResult(this.concept, Result.Status.SKIPPED, Severity.MAJOR);
        ((Store)Mockito.verify((Object)this.store, (VerificationMode)Mockito.never())).create(ConceptDescriptor.class);
    }

    private Result<Concept> verifyConceptResult(Concept expectedConcept, Result.Status expectedStatus, Severity expectedSeverity) throws ReportException {
        ((ReportPlugin)Mockito.verify((Object)this.reportWriter)).beginConcept(expectedConcept);
        ArgumentCaptor resultCaptor = ArgumentCaptor.forClass(Result.class);
        ((ReportPlugin)Mockito.verify((Object)this.reportWriter)).setResult((Result)resultCaptor.capture());
        Result result = (Result)resultCaptor.getValue();
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)CoreMatchers.equalTo((Object)expectedStatus));
        MatcherAssert.assertThat((Object)result.getSeverity(), (Matcher)CoreMatchers.equalTo((Object)expectedSeverity));
        ((ReportPlugin)Mockito.verify((Object)this.reportWriter)).endConcept();
        return result;
    }

    @Test
    void executeConstraint() throws RuleException {
        ((AnalyzerContext)Mockito.doReturn((Object)Result.Status.FAILURE).when((Object)this.analyzerContext)).verify((ExecutableRule)((Constraint)ArgumentMatchers.eq((Object)this.constraint)), (Severity)ArgumentMatchers.eq((Object)Severity.BLOCKER), ArgumentMatchers.anyList(), ArgumentMatchers.anyList());
        this.analyzerRuleVisitor.visitConstraint(this.constraint, Severity.BLOCKER);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Map.class);
        ((Store)Mockito.verify((Object)this.store)).executeQuery((String)ArgumentMatchers.eq((Object)STATEMENT), (Map)argumentCaptor.capture());
        Map parameters = (Map)argumentCaptor.getValue();
        MatcherAssert.assertThat(parameters.get(PARAMETER_WITHOUT_DEFAULT), (Matcher)CoreMatchers.equalTo((Object)"value"));
        MatcherAssert.assertThat(parameters.get(PARAMETER_WITH_DEFAULT), (Matcher)CoreMatchers.equalTo((Object)"defaultValue"));
        this.verifyConstraintResult(Result.Status.FAILURE, Severity.BLOCKER);
    }

    @Test
    void abstractConstraint() throws RuleException {
        Constraint abstractConstraint = this.createConstraint(null);
        this.analyzerRuleVisitor.visitConstraint(abstractConstraint, Severity.BLOCKER);
        Result<?> result = this.verifyConstraintResult(Result.Status.SUCCESS, Severity.BLOCKER);
        MatcherAssert.assertThat((Object)result.getColumnNames(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)result.getRows(), (Matcher)Matchers.empty());
    }

    @Test
    void skipConstraint() throws RuleException {
        this.analyzerRuleVisitor.skipConstraint(this.constraint, Severity.BLOCKER);
        ((Store)Mockito.verify((Object)this.store, (VerificationMode)Mockito.never())).executeQuery((String)ArgumentMatchers.eq((Object)STATEMENT), Mockito.anyMap());
        this.verifyConstraintResult(Result.Status.SKIPPED, Severity.BLOCKER);
    }

    private Result<?> verifyConstraintResult(Result.Status expectedStatus, Severity expectedSeverity) throws ReportException {
        ((ReportPlugin)Mockito.verify((Object)this.reportWriter)).beginConstraint(this.constraint);
        ArgumentCaptor resultCaptor = ArgumentCaptor.forClass(Result.class);
        ((ReportPlugin)Mockito.verify((Object)this.reportWriter)).setResult((Result)resultCaptor.capture());
        Result result = (Result)resultCaptor.getValue();
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)CoreMatchers.equalTo((Object)expectedStatus));
        MatcherAssert.assertThat((Object)result.getSeverity(), (Matcher)CoreMatchers.equalTo((Object)expectedSeverity));
        ((ReportPlugin)Mockito.verify((Object)this.reportWriter)).endConstraint();
        return result;
    }

    @Test
    void skipAppliedConcept() throws RuleException {
        ConceptDescriptor conceptDescriptor = (ConceptDescriptor)Mockito.mock(ConceptDescriptor.class);
        ((ConceptDescriptor)Mockito.doReturn((Object)Result.Status.SUCCESS).when((Object)conceptDescriptor)).getStatus();
        Mockito.when((Object)((ConceptDescriptor)this.store.find(ConceptDescriptor.class, this.concept.getId()))).thenReturn((Object)conceptDescriptor);
        MatcherAssert.assertThat((Object)this.analyzerRuleVisitor.visitConcept(this.concept, Severity.MINOR, Collections.emptyMap()), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        ((ReportPlugin)Mockito.verify((Object)this.reportWriter, (VerificationMode)Mockito.never())).beginConcept(this.concept);
        ((ReportPlugin)Mockito.verify((Object)this.reportWriter, (VerificationMode)Mockito.never())).endConcept();
        ((Store)Mockito.verify((Object)this.store, (VerificationMode)Mockito.never())).create(ConceptDescriptor.class);
        ((Store)Mockito.verify((Object)this.store, (VerificationMode)Mockito.never())).executeQuery((String)ArgumentMatchers.eq((Object)STATEMENT), Mockito.anyMap());
    }

    @Test
    void executeAppliedConcept() throws RuleException {
        ((AnalyzerContext)Mockito.doReturn((Object)Result.Status.SUCCESS).when((Object)this.analyzerContext)).verify((ExecutableRule)((Concept)ArgumentMatchers.eq((Object)this.concept)), (Severity)ArgumentMatchers.eq((Object)Severity.MINOR), ArgumentMatchers.anyList(), ArgumentMatchers.anyList());
        ConceptDescriptor conceptDescriptor = (ConceptDescriptor)Mockito.mock(ConceptDescriptor.class);
        Mockito.when((Object)((ConceptDescriptor)this.store.find(ConceptDescriptor.class, this.concept.getId()))).thenReturn((Object)conceptDescriptor);
        ((Analyze)Mockito.doReturn((Object)true).when((Object)this.configuration)).executeAppliedConcepts();
        MatcherAssert.assertThat((Object)this.analyzerRuleVisitor.visitConcept(this.concept, Severity.MINOR, Collections.emptyMap()), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        ((ReportPlugin)Mockito.verify((Object)this.reportWriter)).beginConcept(this.concept);
        ((Store)Mockito.verify((Object)this.store, (VerificationMode)Mockito.never())).create(ConceptDescriptor.class);
    }

    @Test
    void missingParameter() {
        ((Analyze)Mockito.doReturn(Collections.emptyMap()).when((Object)this.configuration)).ruleParameters();
        ReportPlugin reportWriter = (ReportPlugin)Mockito.mock(ReportPlugin.class);
        try {
            AnalyzerRuleVisitor analyzerRuleVisitor = new AnalyzerRuleVisitor(this.configuration, this.analyzerContext, this.ruleInterpreterPlugins, reportWriter);
            analyzerRuleVisitor.visitConcept(this.concept, Severity.MINOR, Collections.emptyMap());
            Assert.fail((String)("Expecting an " + RuleException.class.getName()));
        }
        catch (RuleException e) {
            String message = e.getMessage();
            MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)this.concept.getId()));
            MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)PARAMETER_WITHOUT_DEFAULT));
        }
    }

    @Test
    void ruleSourceInErrorMessage() {
        Mockito.when((Object)this.store.executeQuery((String)ArgumentMatchers.eq((Object)STATEMENT), Mockito.anyMap())).thenThrow(new Throwable[]{new IllegalStateException("An error")});
        ReportPlugin reportWriter = (ReportPlugin)Mockito.mock(ReportPlugin.class);
        try {
            AnalyzerRuleVisitor analyzerRuleVisitor = new AnalyzerRuleVisitor(this.configuration, this.analyzerContext, this.ruleInterpreterPlugins, reportWriter);
            analyzerRuleVisitor.visitConcept(this.concept, Severity.MINOR, Collections.emptyMap());
            Assert.fail((String)("Expecting a " + RuleException.class.getName()));
        }
        catch (RuleException e) {
            String message = e.getMessage();
            MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"test.xml"));
        }
    }

    private Concept createConcept(String id) {
        return this.createConcept(id, STATEMENT);
    }

    private Concept createConcept(String id, String statement) {
        CypherExecutable executable = statement != null ? new CypherExecutable(statement) : null;
        Parameter parameterWithoutDefaultValue = new Parameter(PARAMETER_WITHOUT_DEFAULT, Parameter.Type.STRING, null);
        Parameter parameterWithDefaultValue = new Parameter(PARAMETER_WITH_DEFAULT, Parameter.Type.STRING, (Object)"defaultValue");
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        parameters.put(parameterWithoutDefaultValue.getName(), parameterWithoutDefaultValue);
        parameters.put(parameterWithDefaultValue.getName(), parameterWithDefaultValue);
        Report report = Report.builder().primaryColumn("primaryColumn").build();
        return (Concept)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)Concept.builder().id(id)).description("Test Concept")).ruleSource((RuleSource)FILE_RULE_SOURCE)).severity(Severity.MINOR)).executable((Executable)executable)).parameters(parameters)).verification((Verification)ROW_COUNT_VERIFICATION)).report(report)).build();
    }

    private Constraint createConstraint(String statement) {
        CypherExecutable executable = statement != null ? new CypherExecutable(statement) : null;
        Parameter parameterWithoutDefaultValue = new Parameter(PARAMETER_WITHOUT_DEFAULT, Parameter.Type.STRING, null);
        Parameter parameterWithDefaultValue = new Parameter(PARAMETER_WITH_DEFAULT, Parameter.Type.STRING, (Object)"defaultValue");
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        parameters.put(parameterWithoutDefaultValue.getName(), parameterWithoutDefaultValue);
        parameters.put(parameterWithDefaultValue.getName(), parameterWithDefaultValue);
        Report report = Report.builder().primaryColumn("primaryColumn").build();
        return (Constraint)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)Constraint.builder().id("test:Constraint")).description("Test Constraint")).ruleSource((RuleSource)FILE_RULE_SOURCE)).severity(Severity.MAJOR)).executable((Executable)executable)).parameters(parameters)).verification((Verification)ROW_COUNT_VERIFICATION)).report(report)).build();
    }

    private Query.Result<Query.Result.CompositeRowObject> createResult(List<String> columnNames) {
        Query.Result.CompositeRowObject row = (Query.Result.CompositeRowObject)Mockito.mock(Query.Result.CompositeRowObject.class);
        Mockito.when((Object)row.getColumns()).thenReturn(columnNames);
        ResultIterator iterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)((Query.Result.CompositeRowObject)iterator.next())).thenReturn((Object)row);
        Query.Result result = (Query.Result)Mockito.mock(Query.Result.class);
        Mockito.when((Object)result.iterator()).thenReturn((Object)iterator);
        return result;
    }

    private Query.Result<Query.Result.CompositeRowObject> createEmptyResult() {
        Query.Result.CompositeRowObject row = (Query.Result.CompositeRowObject)Mockito.mock(Query.Result.CompositeRowObject.class);
        Mockito.when((Object)row.getColumns()).thenReturn(Collections.emptyList());
        ResultIterator iterator = (ResultIterator)Mockito.mock(ResultIterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)false);
        Query.Result result = (Query.Result)Mockito.mock(Query.Result.class);
        Mockito.when((Object)result.iterator()).thenReturn((Object)iterator);
        return result;
    }
}

