/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerContext;
import com.buschmais.jqassistant.core.analysis.api.configuration.Analyze;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerContextImpl;
import com.buschmais.jqassistant.core.report.api.configuration.Report;
import com.buschmais.jqassistant.core.report.api.model.Row;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.shared.map.MapBuilder;
import com.buschmais.jqassistant.core.store.api.Store;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class AnalyzerContextImplTest {
    private AnalyzerContext analyzerContext;
    @Mock
    private Analyze configuration;
    @Mock
    private Report report;
    @Mock
    private Store store;

    AnalyzerContextImplTest() {
    }

    @BeforeEach
    void setUp() {
        ((Analyze)Mockito.doReturn((Object)this.report).when((Object)this.configuration)).report();
        ((Report)Mockito.doReturn((Object)Severity.MINOR).when((Object)this.report)).warnOnSeverity();
        ((Report)Mockito.doReturn((Object)Severity.MAJOR).when((Object)this.report)).failOnSeverity();
        this.analyzerContext = new AnalyzerContextImpl(this.configuration, this.getClass().getClassLoader(), this.store);
    }

    @Test
    void createUniqueRowKeys() {
        Concept concept1 = (Concept)((Concept.ConceptBuilder)Concept.builder().id("id1")).build();
        Concept concept2 = (Concept)((Concept.ConceptBuilder)Concept.builder().id("id2")).build();
        Row row1_1 = this.analyzerContext.toRow((ExecutableRule)concept1, MapBuilder.builder().entry((Object)"c1", (Object)this.analyzerContext.toColumn((Object)"v1")).entry((Object)"c2", (Object)this.analyzerContext.toColumn((Object)"v2")).build());
        Row row1_2 = this.analyzerContext.toRow((ExecutableRule)concept1, MapBuilder.builder().entry((Object)"c1", (Object)this.analyzerContext.toColumn((Object)"v1")).entry((Object)"c2", (Object)this.analyzerContext.toColumn((Object)"v3")).build());
        Row row2_1 = this.analyzerContext.toRow((ExecutableRule)concept2, MapBuilder.builder().entry((Object)"c1", (Object)this.analyzerContext.toColumn((Object)"v1")).entry((Object)"c2", (Object)this.analyzerContext.toColumn((Object)"v2")).build());
        Set rowKeys = Stream.of(row1_1, row1_2, row2_1).map(row -> row.getKey()).collect(Collectors.toSet());
        Assertions.assertThat(rowKeys).hasSize(3);
    }
}

