/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerContext;
import com.buschmais.jqassistant.core.analysis.impl.CypherRuleInterpreterPlugin;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.api.model.Suppress;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Report;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.shared.transaction.Transactional;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.xo.api.Query;
import com.buschmais.xo.api.ResultIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CypherRuleInterpreterPluginTest {
    private static final String CONSTRAINT_ID = "constraint";
    public static final String PRIMARY_COLUMN = "primary";
    public static final String SECONDARY_COLUMN = "secondary";
    private CypherRuleInterpreterPlugin interpreterPlugin = new CypherRuleInterpreterPlugin();
    @Mock
    private AnalyzerContext analyzerContext;
    @Mock
    private Store store;

    CypherRuleInterpreterPluginTest() {
    }

    @BeforeEach
    void beforeEach() {
        ((AnalyzerContext)Mockito.doReturn((Object)this.store).when((Object)this.analyzerContext)).getStore();
        ((Store)Mockito.doAnswer(invocation -> ((Transactional.TransactionalSupplier)invocation.getArgument(0)).execute()).when((Object)this.store)).requireTransaction((Transactional.TransactionalSupplier)ArgumentMatchers.any(Transactional.TransactionalSupplier.class));
    }

    @Test
    void withoutSuppression() throws RuleException {
        Constraint constraint = this.prepareConstraint(Map.of(PRIMARY_COLUMN, "value1_1", SECONDARY_COLUMN, "value1_2"), Map.of(PRIMARY_COLUMN, "value2_1", SECONDARY_COLUMN, "value2_2"));
        Result result = this.interpreterPlugin.execute("MATCH n RETURN n", (ExecutableRule)constraint, Collections.emptyMap(), Severity.MAJOR, this.analyzerContext);
        Assertions.assertThat((List)result.getRows()).hasSize(2);
    }

    @Test
    void suppressByPrimaryColumn() throws RuleException {
        Suppress suppressedValue = CypherRuleInterpreterPluginTest.createSuppressedValue(Optional.empty(), CONSTRAINT_ID);
        Constraint constraint = this.prepareConstraint(Map.of(PRIMARY_COLUMN, suppressedValue, SECONDARY_COLUMN, "value"));
        Result result = this.interpreterPlugin.execute("MATCH n RETURN n", (ExecutableRule)constraint, Collections.emptyMap(), Severity.MAJOR, this.analyzerContext);
        Assertions.assertThat((List)result.getRows()).isEmpty();
    }

    @Test
    void suppressByNonPrimaryColumn() throws RuleException {
        Suppress suppressedValue = CypherRuleInterpreterPluginTest.createSuppressedValue(Optional.of(SECONDARY_COLUMN), CONSTRAINT_ID);
        Constraint constraint = this.prepareConstraint(Map.of(PRIMARY_COLUMN, "value", SECONDARY_COLUMN, suppressedValue));
        Result result = this.interpreterPlugin.execute("MATCH n RETURN n", (ExecutableRule)constraint, Collections.emptyMap(), Severity.MAJOR, this.analyzerContext);
        Assertions.assertThat((List)result.getRows()).isEmpty();
    }

    @Test
    void nonMatchingSuppressId() throws RuleException {
        Suppress suppressedValue = CypherRuleInterpreterPluginTest.createSuppressedValue(Optional.empty(), "otherConstraint");
        Constraint constraint = this.prepareConstraint(Map.of(PRIMARY_COLUMN, suppressedValue, SECONDARY_COLUMN, "value"));
        Result result = this.interpreterPlugin.execute("MATCH n RETURN n", (ExecutableRule)constraint, Collections.emptyMap(), Severity.MAJOR, this.analyzerContext);
        Assertions.assertThat((List)result.getRows()).hasSize(1);
    }

    private Constraint prepareConstraint(Map<String, Object> ... resultRows) {
        Report report = Report.builder().primaryColumn(PRIMARY_COLUMN).build();
        Constraint constraint = (Constraint)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)Constraint.builder().id(CONSTRAINT_ID)).report(report)).build();
        ResultIterator<Query.Result.CompositeRowObject> resultIterator = CypherRuleInterpreterPluginTest.asResultIterator(Arrays.stream(resultRows).map(this::asRow).collect(Collectors.toList()));
        Query.Result queryResult = (Query.Result)Mockito.mock(Query.Result.class);
        ((Query.Result)Mockito.doReturn(resultIterator).when((Object)queryResult)).iterator();
        ((Store)Mockito.doReturn((Object)queryResult).when((Object)this.store)).executeQuery(ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        return constraint;
    }

    private static Suppress createSuppressedValue(final Optional<String> suppressColumn, final String ... suppressIds) {
        Suppress suppress = new Suppress(){

            public String[] getSuppressIds() {
                return suppressIds;
            }

            public void setSuppressIds(String[] suppressIds2) {
            }

            public String getSuppressColumn() {
                return suppressColumn.orElse(null);
            }

            public void setSuppressColumn(String suppressColumn2) {
            }
        };
        return suppress;
    }

    private static ResultIterator<Query.Result.CompositeRowObject> asResultIterator(List<Query.Result.CompositeRowObject> queryRows) {
        final Iterator<Query.Result.CompositeRowObject> iterator = queryRows.iterator();
        ResultIterator<Query.Result.CompositeRowObject> resultIterator = new ResultIterator<Query.Result.CompositeRowObject>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Query.Result.CompositeRowObject next() {
                return (Query.Result.CompositeRowObject)iterator.next();
            }

            public void close() {
            }
        };
        return resultIterator;
    }

    private Query.Result.CompositeRowObject asRow(final Map<String, Object> row) {
        return new Query.Result.CompositeRowObject(){

            public List<String> getColumns() {
                return new ArrayList<String>(row.keySet());
            }

            public <C> C get(String column, Class<C> columnType) {
                return columnType.cast(row.get(column));
            }

            public <I> I getId() {
                return (I)Integer.valueOf(row.hashCode());
            }

            public <T> T as(Class<T> aClass) {
                return aClass.cast(row);
            }

            public <D> D getDelegate() {
                return (D)row;
            }
        };
    }
}

