/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.impl.RowCountVerificationStrategy;
import com.buschmais.jqassistant.core.report.api.configuration.Report;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.api.model.Row;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.api.reader.RowCountVerification;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class RowCountVerificationStrategyTest {
    static final List<String> COLUMN_NAMES = Collections.singletonList("a");
    @Mock
    private Report configuration;
    @Mock
    private Concept concept;
    @Mock
    private Constraint constraint;
    @Mock
    private List<Row> result;
    private RowCountVerificationStrategy strategy;

    RowCountVerificationStrategyTest() {
    }

    @BeforeEach
    void setUp() {
        ((Report)Mockito.doReturn((Object)Severity.MINOR).when((Object)this.configuration)).warnOnSeverity();
        ((Report)Mockito.doReturn((Object)Severity.MAJOR).when((Object)this.configuration)).failOnSeverity();
        this.strategy = new RowCountVerificationStrategy(this.configuration);
    }

    @Test
    void defaultConfiguration() {
        RowCountVerification rowCountVerification = RowCountVerification.builder().build();
        Mockito.when((Object)this.result.size()).thenReturn((Object)0);
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        Mockito.when((Object)this.result.size()).thenReturn((Object)1);
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
    }

    @Test
    void min() {
        RowCountVerification rowCountVerification = RowCountVerification.builder().min(Integer.valueOf(1)).build();
        Mockito.when((Object)this.result.size()).thenReturn((Object)0);
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
        Mockito.when((Object)this.result.size()).thenReturn((Object)1);
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
    }

    @Test
    void max() {
        RowCountVerification rowCountVerification = RowCountVerification.builder().max(Integer.valueOf(0)).build();
        Mockito.when((Object)this.result.size()).thenReturn((Object)0);
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        Mockito.when((Object)this.result.size()).thenReturn((Object)1);
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
    }

    @Test
    void minMax() {
        RowCountVerification rowCountVerification = RowCountVerification.builder().min(Integer.valueOf(1)).max(Integer.valueOf(1)).build();
        Mockito.when((Object)this.result.size()).thenReturn((Object)0);
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
        Mockito.when((Object)this.result.size()).thenReturn((Object)1);
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.SUCCESS));
        Mockito.when((Object)this.result.size()).thenReturn((Object)2);
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.concept, Severity.MINOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.WARNING));
        MatcherAssert.assertThat((Object)this.strategy.verify((ExecutableRule)this.constraint, Severity.MAJOR, rowCountVerification, COLUMN_NAMES, this.result), (Matcher)CoreMatchers.equalTo((Object)Result.Status.FAILURE));
    }
}

