/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerContext;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.analysis.api.configuration.Analyze;
import com.buschmais.jqassistant.core.analysis.api.model.AnalyzeTaskDescriptor;
import com.buschmais.jqassistant.core.analysis.api.model.ConceptDescriptor;
import com.buschmais.jqassistant.core.analysis.api.model.ConstraintDescriptor;
import com.buschmais.jqassistant.core.analysis.api.model.ExecutableRuleTemplate;
import com.buschmais.jqassistant.core.analysis.api.model.GroupDescriptor;
import com.buschmais.jqassistant.core.analysis.api.model.RuleDescriptor;
import com.buschmais.jqassistant.core.analysis.api.model.RuleGroupTemplate;
import com.buschmais.jqassistant.core.analysis.spi.RuleRepository;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.executor.AbstractRuleVisitor;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.Executable;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.Parameter;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.api.model.SeverityRule;
import com.buschmais.jqassistant.core.store.api.Store;
import io.smallrye.config.ConfigMapping;
import java.time.LocalDateTime;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerRuleVisitor
extends AbstractRuleVisitor<Result.Status> {
    private static final Logger log = LoggerFactory.getLogger(AnalyzerRuleVisitor.class);
    private final Analyze configuration;
    private final AnalyzerContext analyzerContext;
    private final ReportPlugin reportPlugin;
    private final Map<String, Collection<RuleInterpreterPlugin>> ruleInterpreterPlugins;
    private final Store store;
    private final RuleRepository ruleRepository;
    private final Deque<RuleGroupTemplate> ruleGroups = new ArrayDeque<RuleGroupTemplate>();

    AnalyzerRuleVisitor(Analyze configuration, AnalyzerContext analyzerContext, Map<String, Collection<RuleInterpreterPlugin>> ruleInterpreterPlugins, ReportPlugin reportPlugin) {
        this.configuration = configuration;
        this.analyzerContext = analyzerContext;
        this.ruleInterpreterPlugins = ruleInterpreterPlugins;
        this.reportPlugin = reportPlugin;
        this.store = analyzerContext.getStore();
        this.ruleRepository = (RuleRepository)this.store.getXOManager().getRepository(RuleRepository.class);
    }

    public boolean isSuccess(Result.Status result) {
        return Result.Status.SUCCESS.equals((Object)result);
    }

    public void beforeRules() throws RuleException {
        this.store.requireTransaction(() -> {
            AnalyzeTaskDescriptor analyzeTaskDescriptor = (AnalyzeTaskDescriptor)this.store.create(AnalyzeTaskDescriptor.class);
            analyzeTaskDescriptor.setTimestamp(LocalDateTime.now());
            this.ruleGroups.push(analyzeTaskDescriptor);
            this.reportPlugin.begin();
        });
    }

    public void afterRules() throws RuleException {
        this.store.requireTransaction(() -> ((ReportPlugin)this.reportPlugin).end());
        this.ruleGroups.pop();
    }

    public Result.Status visitConcept(Concept concept, Severity effectiveSeverity, Map<Map.Entry<Concept, Boolean>, Result.Status> requiredConceptResults, Map<Concept, Result.Status> providingConceptResults) throws RuleException {
        ConceptDescriptor conceptDescriptor = this.findConcept(concept);
        if (conceptDescriptor == null || this.configuration.executeAppliedConcepts()) {
            log.info("Applying concept '{}' with severity: '{}'.", (Object)concept.getId(), (Object)effectiveSeverity.getInfo(concept.getSeverity()));
            this.store.requireTransaction(() -> this.reportPlugin.beginConcept(concept, requiredConceptResults, providingConceptResults));
            Result<Concept> result = this.execute(concept, effectiveSeverity);
            this.store.requireTransaction(() -> this.reportPlugin.setResult(result));
            this.store.requireTransaction(() -> ((ReportPlugin)this.reportPlugin).endConcept());
            Result.Status status = AnalyzerRuleVisitor.evaluateConceptStatus(result, providingConceptResults);
            this.updateConcept(concept, effectiveSeverity, providingConceptResults.keySet(), status);
            return status;
        }
        log.info("Concept '{}' has already been applied, skipping (activate '{}.{}' to force execution).", new Object[]{concept.getId(), Analyze.class.getAnnotation(ConfigMapping.class).prefix(), "execute-applied-concepts"});
        return (Result.Status)this.store.requireTransaction(conceptDescriptor::getStatus);
    }

    private static Result.Status evaluateConceptStatus(Result<Concept> result, Map<Concept, Result.Status> providedConceptResults) {
        return Stream.of(Collections.singletonList(result.getStatus()), providedConceptResults.values()).flatMap(Collection::stream).filter(arg_0 -> Result.Status.SUCCESS.equals(arg_0)).findAny().orElse(Result.Status.FAILURE);
    }

    public void skipConcept(Concept concept, Severity effectiveSeverity, Map<Map.Entry<Concept, Boolean>, Result.Status> requiredConceptResults) throws RuleException {
        this.store.requireTransaction(() -> this.reportPlugin.beginConcept(concept, requiredConceptResults, Collections.emptyMap()));
        Result result = Result.builder().rule((ExecutableRule)concept).status(Result.Status.SKIPPED).severity(effectiveSeverity).build();
        this.store.requireTransaction(() -> this.reportPlugin.setResult(result));
        this.store.requireTransaction(() -> ((ReportPlugin)this.reportPlugin).endConcept());
    }

    public Result.Status visitConstraint(Constraint constraint, Severity effectiveSeverity, Map<Map.Entry<Concept, Boolean>, Result.Status> requiredConceptResults) throws RuleException {
        log.info("Validating constraint '{}' with severity: '{}'.", (Object)constraint.getId(), (Object)effectiveSeverity.getInfo(constraint.getSeverity()));
        this.store.requireTransaction(() -> this.reportPlugin.beginConstraint(constraint, requiredConceptResults));
        Result<Constraint> result = this.execute(constraint, effectiveSeverity);
        this.store.requireTransaction(() -> this.reportPlugin.setResult(result));
        this.store.requireTransaction(() -> ((ReportPlugin)this.reportPlugin).endConstraint());
        Result.Status status = result.getStatus();
        this.updateConstraint(constraint, effectiveSeverity, status);
        return status;
    }

    public void skipConstraint(Constraint constraint, Severity effectiveSeverity, Map<Map.Entry<Concept, Boolean>, Result.Status> requiredConceptResults) throws RuleException {
        this.store.requireTransaction(() -> this.reportPlugin.beginConstraint(constraint, requiredConceptResults));
        Result result = Result.builder().rule((ExecutableRule)constraint).status(Result.Status.SKIPPED).severity(effectiveSeverity).build();
        this.store.requireTransaction(() -> this.reportPlugin.setResult(result));
        this.store.requireTransaction(() -> ((ReportPlugin)this.reportPlugin).endConstraint());
    }

    public void beforeGroup(Group group, Severity effectiveSeverity) throws RuleException {
        log.info("Executing group '{}'", (Object)group.getId());
        this.store.requireTransaction(() -> this.reportPlugin.beginGroup(group));
        this.updateGroup(group, effectiveSeverity);
    }

    public void afterGroup(Group group) throws RuleException {
        this.store.requireTransaction(() -> ((ReportPlugin)this.reportPlugin).endGroup());
        this.ruleGroups.pop();
    }

    private <T extends ExecutableRule<?>> Result<T> execute(T executableRule, Severity severity) throws RuleException {
        Executable executable = executableRule.getExecutable();
        if (executable == null) {
            return Result.builder().rule(executableRule).status(Result.Status.SUCCESS).severity(severity).columnNames(Collections.emptyList()).rows(Collections.emptyList()).build();
        }
        Map<String, Object> ruleParameters = this.getRuleParameters(executableRule);
        Collection<RuleInterpreterPlugin> languagePlugins = this.ruleInterpreterPlugins.get(executable.getLanguage());
        if (languagePlugins == null) {
            throw new RuleException("Could not determine plugin to execute " + executableRule);
        }
        for (RuleInterpreterPlugin languagePlugin : languagePlugins) {
            Result<T> result;
            if (!languagePlugin.accepts(executableRule) || (result = this.execute(executableRule, severity, ruleParameters, languagePlugin)) == null) continue;
            return result;
        }
        throw new RuleException("No plugin for language '" + executable.getLanguage() + "' returned a result for " + executableRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ExecutableRule<?>> Result<T> execute(T executableRule, Severity severity, Map<String, Object> ruleParameters, RuleInterpreterPlugin languagePlugin) throws RuleException {
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            Result<T> result = languagePlugin.execute(executableRule, ruleParameters, severity, this.analyzerContext);
            return result;
        }
        finally {
            stopWatch.stop();
            long ruleExecutionTime = stopWatch.getTime(TimeUnit.SECONDS);
            if (ruleExecutionTime > (long)this.configuration.warnOnExecutionTimeSeconds()) {
                log.warn("Execution of rule with id '{}' took {} seconds.", (Object)executableRule.getSource().getId(), (Object)ruleExecutionTime);
            }
            if (this.store.hasActiveTransaction()) {
                log.warn("Rule with id '{}' returned with an active transaction, performing rollback. Please check the implementation.", (Object)executableRule.getSource().getId());
                this.store.rollbackTransaction();
            }
        }
    }

    private Map<String, Object> getRuleParameters(ExecutableRule<?> executableRule) throws RuleException {
        HashMap<String, Object> ruleParameters = new HashMap<String, Object>();
        Map parameters = executableRule.getParameters();
        for (Map.Entry entry : parameters.entrySet()) {
            Object parameterValue;
            String parameterName = (String)entry.getKey();
            Parameter parameter = (Parameter)entry.getValue();
            String parameterValueAsString = this.configuration.ruleParameters().get(parameterName);
            if (parameterValueAsString != null) {
                try {
                    parameterValue = parameter.getType().parse(parameterValueAsString);
                }
                catch (RuleException e) {
                    throw new RuleException("Cannot determine value for parameter " + parameterName + "' of rule '" + executableRule + "'.");
                }
            } else {
                parameterValue = parameter.getDefaultValue();
            }
            if (parameterValue == null) {
                throw new RuleException("No value or default value defined for required parameter '" + parameterName + "' of rule '" + executableRule + "'.");
            }
            ruleParameters.put(parameterName, parameterValue);
        }
        return ruleParameters;
    }

    private ConceptDescriptor findConcept(Concept concept) {
        return (ConceptDescriptor)this.store.requireTransaction(() -> this.ruleRepository.findConcept(concept.getId()));
    }

    private void updateConcept(Concept concept, Severity effectiveSeverity, Set<Concept> providingConcepts, Result.Status status) {
        this.store.requireTransaction(() -> {
            ConceptDescriptor conceptDescriptor = this.ruleRepository.mergeConcept(concept.getId());
            this.updateRule((SeverityRule)concept, effectiveSeverity, conceptDescriptor);
            this.updateExecutableRule((ExecutableRule<?>)concept, status, conceptDescriptor);
            for (Concept providingConcept : providingConcepts) {
                this.ruleRepository.mergeConcept(providingConcept.getId()).getProvidesConcepts().add(conceptDescriptor);
            }
            this.updateRuleGroup(ruleGroup -> ruleGroup.getIncludesConcepts().add(conceptDescriptor));
        });
    }

    private void updateConstraint(Constraint constraint, Severity effectiveSeverity, Result.Status status) {
        this.store.requireTransaction(() -> {
            ConstraintDescriptor constraintDescriptor = this.ruleRepository.mergeConstraint(constraint.getId());
            this.updateRule((SeverityRule)constraint, effectiveSeverity, constraintDescriptor);
            this.updateExecutableRule((ExecutableRule<?>)constraint, status, constraintDescriptor);
            this.updateRuleGroup(ruleGroup -> ruleGroup.getIncludesConstraints().add(constraintDescriptor));
        });
    }

    private void updateGroup(Group group, Severity effectiveSeverity) {
        this.store.requireTransaction(() -> {
            GroupDescriptor groupDescriptor = this.ruleRepository.mergeGroup(group.getId());
            this.updateRule((SeverityRule)group, effectiveSeverity, groupDescriptor);
            this.updateRuleGroup(ruleGroup -> ruleGroup.getIncludesGroups().add(groupDescriptor));
            this.ruleGroups.push(groupDescriptor);
        });
    }

    private void updateRuleGroup(Consumer<RuleGroupTemplate> ruleGroupConsumer) {
        if (!this.ruleGroups.isEmpty()) {
            ruleGroupConsumer.accept(this.ruleGroups.peek());
        }
    }

    private void updateRule(SeverityRule rule, Severity effectiveSeverity, RuleDescriptor ruleDescriptor) {
        ruleDescriptor.setSeverity(rule.getSeverity());
        ruleDescriptor.setEffectiveSeverity(effectiveSeverity);
    }

    private void updateExecutableRule(ExecutableRule<?> executableRule, Result.Status status, ExecutableRuleTemplate executableRuleTemplate) {
        for (String requiresConceptId : executableRule.getRequiresConcepts().keySet()) {
            executableRuleTemplate.getRequiresConcepts().add(this.ruleRepository.mergeConcept(requiresConceptId));
        }
        executableRuleTemplate.setStatus(status);
    }
}

