/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerContext;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.Executable;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.impl.SourceExecutable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRuleInterpreterPlugin
implements RuleInterpreterPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptRuleInterpreterPlugin.class);
    private ScriptEngineManager scriptEngineManager;
    private Set<String> languages = new TreeSet<String>();

    public ScriptRuleInterpreterPlugin() {
        this.scriptEngineManager = new ScriptEngineManager();
        for (ScriptEngineFactory factory : this.scriptEngineManager.getEngineFactories()) {
            for (String name : factory.getNames()) {
                this.languages.add(name.toLowerCase());
            }
        }
        LOGGER.debug("Supported languages: {}.", this.languages);
    }

    @Override
    public Collection<String> getLanguages() {
        return this.languages;
    }

    @Override
    public <T extends ExecutableRule<?>> boolean accepts(T executableRule) {
        return executableRule.getExecutable() instanceof SourceExecutable;
    }

    @Override
    public <T extends ExecutableRule<?>> Result<T> execute(T executableRule, Map<String, Object> ruleParameters, Severity severity, AnalyzerContext context) throws RuleException {
        Object scriptResult;
        Executable executable = executableRule.getExecutable();
        String language = executable.getLanguage();
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(language);
        if (scriptEngine == null) {
            ArrayList<String> availableLanguages = new ArrayList<String>();
            for (ScriptEngineFactory factory : this.scriptEngineManager.getEngineFactories()) {
                availableLanguages.addAll(factory.getNames());
            }
            throw new RuleException("Cannot resolve scripting engine for '" + language + "', available languages are " + availableLanguages);
        }
        scriptEngine.put(ScriptVariable.STORE.getVariableName(), context.getStore());
        scriptEngine.put(ScriptVariable.CONTEXT.getVariableName(), context);
        scriptEngine.put(ScriptVariable.RULE.getVariableName(), executableRule);
        scriptEngine.put(ScriptVariable.SEVERITY.getVariableName(), severity);
        for (Map.Entry<String, Object> entry : ruleParameters.entrySet()) {
            scriptEngine.put(entry.getKey(), entry.getValue());
        }
        try {
            scriptResult = scriptEngine.eval((String)executable.getSource());
        }
        catch (ScriptException e) {
            throw new RuleException("Cannot execute script.", (Throwable)e);
        }
        if (!(scriptResult instanceof Result)) {
            throw new RuleException("Script returned an invalid result type, expected " + Result.class.getName() + " but got " + scriptResult);
        }
        return (Result)Result.class.cast(scriptResult);
    }

    private static enum ScriptVariable {
        STORE,
        CONTEXT,
        RULE,
        SEVERITY;


        String getVariableName() {
            return this.name().toLowerCase();
        }
    }
}

