/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerContext;
import com.buschmais.jqassistant.core.analysis.api.baseline.BaselineManager;
import com.buschmais.jqassistant.core.analysis.api.configuration.Analyze;
import com.buschmais.jqassistant.core.analysis.impl.AggregationVerificationStrategy;
import com.buschmais.jqassistant.core.analysis.impl.RowCountVerificationStrategy;
import com.buschmais.jqassistant.core.analysis.impl.VerificationStrategy;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.model.Column;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.api.model.Row;
import com.buschmais.jqassistant.core.report.api.model.Suppress;
import com.buschmais.jqassistant.core.report.api.model.VerificationResult;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.api.model.Verification;
import com.buschmais.jqassistant.core.rule.api.reader.RowCountVerification;
import com.buschmais.jqassistant.core.store.api.Store;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnalyzerContextImpl
implements AnalyzerContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalyzerContextImpl.class);
    private static final Verification DEFAULT_VERIFICATION = RowCountVerification.builder().build();
    private final ClassLoader classLoader;
    private final Store store;
    private final BaselineManager baselineManager;
    private final Map<Class<? extends Verification>, VerificationStrategy<?>> verificationStrategies;
    private final Severity.Threshold warnOnSeverity;
    private final Severity.Threshold failOnSeverity;

    AnalyzerContextImpl(Analyze configuration, ClassLoader classLoader, Store store, BaselineManager baselineManager) throws RuleException {
        this.classLoader = classLoader;
        this.store = store;
        this.baselineManager = baselineManager;
        this.warnOnSeverity = Severity.Threshold.from((String)configuration.report().warnOnSeverity());
        this.failOnSeverity = Severity.Threshold.from((String)configuration.report().failOnSeverity());
        this.verificationStrategies = Stream.of(new RowCountVerificationStrategy(), new AggregationVerificationStrategy()).collect(Collectors.toMap(VerificationStrategy::getVerificationType, strategy -> strategy));
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    public <T> Column<T> toColumn(T value) {
        return ReportHelper.toColumn(value);
    }

    @Override
    public Row toRow(ExecutableRule<?> rule, Map<String, Column<?>> columns) {
        return ReportHelper.toRow(rule, columns);
    }

    @Override
    public <T extends ExecutableRule<?>> boolean isSuppressed(T executableRule, String primaryColumn, Row row) {
        if (this.baselineManager.isExisting(executableRule, row)) {
            return true;
        }
        String ruleId = executableRule.getId();
        Map columns = row.getColumns();
        for (Map.Entry entry : columns.entrySet()) {
            String[] suppressIds;
            Suppress suppress;
            String suppressColumn;
            String columnName = (String)entry.getKey();
            Column column = (Column)entry.getValue();
            Object columnValue = column.getValue();
            if (columnValue == null || !Suppress.class.isAssignableFrom(columnValue.getClass()) || ((suppressColumn = (suppress = (Suppress)columnValue).getSuppressColumn()) == null || !suppressColumn.equals(columnName)) && !primaryColumn.equals(columnName)) continue;
            for (String suppressId : suppressIds = suppress.getSuppressIds()) {
                if (!ruleId.equals(suppressId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public <T extends ExecutableRule<?>> VerificationResult verify(T executable, List<String> columnNames, List<Row> rows) throws RuleException {
        VerificationStrategy<?> strategy;
        Verification verification = executable.getVerification();
        if (verification == null) {
            log.debug("Using default verification for '{}'.", executable);
            verification = DEFAULT_VERIFICATION;
        }
        if ((strategy = this.verificationStrategies.get(verification.getClass())) == null) {
            throw new RuleException("Result verification not supported: " + verification.getClass().getName());
        }
        return strategy.verify(executable, verification, columnNames, rows);
    }

    @Override
    public Result.Status getStatus(VerificationResult verificationResult, Severity severity) {
        if (!verificationResult.isSuccess()) {
            if (severity.exceeds(this.failOnSeverity)) {
                return Result.Status.FAILURE;
            }
            if (severity.exceeds(this.warnOnSeverity)) {
                return Result.Status.WARNING;
            }
        }
        return Result.Status.SUCCESS;
    }
}

