/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.baseline;

import com.buschmais.jqassistant.core.analysis.api.baseline.Baseline;
import com.buschmais.jqassistant.core.analysis.api.baseline.BaselineRepository;
import com.buschmais.jqassistant.core.report.api.model.Column;
import com.buschmais.jqassistant.core.report.api.model.Row;
import com.buschmais.jqassistant.core.rule.api.filter.RuleFilter;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaselineManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaselineManager.class);
    private final com.buschmais.jqassistant.core.analysis.api.configuration.Baseline configuration;
    private final BaselineRepository baselineRepository;
    private Optional<Baseline> optionalOldBaseline;
    private Baseline newBaseline;

    public void start() {
        if (this.configuration.enabled()) {
            this.optionalOldBaseline = this.baselineRepository.read();
            this.newBaseline = new Baseline();
        }
    }

    public void stop() {
        if (!(!this.configuration.enabled() || this.optionalOldBaseline.isPresent() && this.newBaseline.equals(this.optionalOldBaseline.get()))) {
            log.info("Baseline has been updated.");
            this.baselineRepository.write(this.newBaseline);
        }
    }

    public boolean isExisting(ExecutableRule<?> executableRule, Row row) {
        if (!this.configuration.enabled()) {
            return false;
        }
        if (this.newBaseline == null) {
            throw new IllegalStateException("Baseline manager has not been started yet");
        }
        if (executableRule instanceof Concept) {
            return this.isExistingResult(executableRule, row, this.configuration.includeConcepts().orElse(Collections.emptyList()), Baseline::getConcepts);
        }
        if (executableRule instanceof Constraint) {
            return this.isExistingResult(executableRule, row, this.configuration.includeConstraints(), Baseline::getConstraints);
        }
        throw new IllegalArgumentException("Unsupported executable rule: " + String.valueOf(executableRule));
    }

    private Boolean isExistingResult(ExecutableRule<?> executableRule, Row row, List<String> ruleFilters, Function<Baseline, SortedMap<String, Baseline.RuleBaseline>> rows) {
        String ruleId = executableRule.getId();
        if (ruleFilters.stream().noneMatch(filter -> RuleFilter.matches((String)ruleId, (String)filter))) {
            return false;
        }
        String rowKey = row.getKey();
        Map columns = row.getColumns();
        return this.optionalOldBaseline.map(oldBaseline -> {
            SortedMap ruleBaseline = (SortedMap)rows.apply((Baseline)oldBaseline);
            Baseline.RuleBaseline oldRuleBaseline = (Baseline.RuleBaseline)ruleBaseline.get(ruleId);
            if (oldRuleBaseline != null && oldRuleBaseline.getRows().containsKey(rowKey)) {
                this.addToNewBaseline(ruleId, rowKey, columns, rows);
                return true;
            }
            return false;
        }).orElseGet(() -> {
            this.addToNewBaseline(ruleId, rowKey, columns, rows);
            return false;
        });
    }

    private void addToNewBaseline(String constraintId, String rowKey, Map<String, Column<?>> columns, Function<Baseline, SortedMap<String, Baseline.RuleBaseline>> rows) {
        Baseline.RuleBaseline newRuleBaseline = rows.apply(this.newBaseline).computeIfAbsent(constraintId, key -> new Baseline.RuleBaseline());
        TreeMap row = new TreeMap();
        columns.entrySet().stream().forEach(entry -> row.put((String)entry.getKey(), ((Column)entry.getValue()).getLabel()));
        newRuleBaseline.getRows().put(rowKey, row);
    }

    @Generated
    public BaselineManager(com.buschmais.jqassistant.core.analysis.api.configuration.Baseline configuration, BaselineRepository baselineRepository) {
        this.configuration = configuration;
        this.baselineRepository = baselineRepository;
    }
}

