/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api;

import com.buschmais.jqassistant.core.rule.api.configuration.Rule;
import com.buschmais.jqassistant.core.rule.api.executor.CollectRulesVisitor;
import com.buschmais.jqassistant.core.rule.api.executor.RuleSetExecutor;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleHelper.class);
    public static final String LOG_LINE_PREFIX = "  \"";

    public void printRuleSet(RuleSet ruleSet, Rule configuration) throws RuleException {
        RuleSelection ruleSelection = RuleSelection.builder().conceptIds(ruleSet.getConceptBucket().getIds()).constraintIds(ruleSet.getConstraintBucket().getIds()).groupIds(ruleSet.getGroupsBucket().getIds()).build();
        this.printRuleSet(ruleSet, ruleSelection, configuration);
    }

    public void printRuleSet(RuleSet ruleSet, RuleSelection ruleSelection, Rule configuration) throws RuleException {
        CollectRulesVisitor visitor = this.getAllRules(ruleSet, ruleSelection, configuration);
        this.printValidRules(visitor);
    }

    private void printValidRules(CollectRulesVisitor visitor) {
        log.info("Groups [" + visitor.getGroups().size() + "]");
        for (Group group : visitor.getGroups()) {
            log.info(LOG_LINE_PREFIX + group.getId() + "\"");
        }
        log.info("Constraints [" + visitor.getConstraints().size() + "]");
        for (Constraint constraint : visitor.getConstraints().keySet()) {
            log.info(LOG_LINE_PREFIX + constraint.getId() + "\" - " + constraint.getDescription());
        }
        log.info("Concepts [" + visitor.getConcepts().size() + "]");
        for (Concept concept : visitor.getConcepts().keySet()) {
            log.info(LOG_LINE_PREFIX + concept.getId() + "\" - " + concept.getDescription());
        }
    }

    public CollectRulesVisitor getAllRules(RuleSet ruleSet, RuleSelection ruleSelection, Rule configuration) throws RuleException {
        CollectRulesVisitor visitor = new CollectRulesVisitor();
        RuleSetExecutor<Boolean> executor = new RuleSetExecutor<Boolean>(visitor, configuration);
        executor.execute(ruleSet, ruleSelection);
        return visitor;
    }
}

