/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.executor;

import com.buschmais.jqassistant.core.rule.api.configuration.Rule;
import com.buschmais.jqassistant.core.rule.api.executor.AbstractRuleVisitor;
import com.buschmais.jqassistant.core.rule.api.executor.RuleVisitor;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleSetExecutor<R> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleSetExecutor.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleSetExecutor.class);
    private final Map<Concept, R> executedConcepts = new HashMap<Concept, R>();
    private final Set<Constraint> executedConstraints = new LinkedHashSet<Constraint>();
    private final Set<Group> executedGroups = new LinkedHashSet<Group>();
    private final RuleVisitor<R> ruleVisitor;
    private final Rule configuration;

    public RuleSetExecutor(RuleVisitor<R> ruleVisitor, Rule configuration) {
        this.ruleVisitor = ruleVisitor;
        this.configuration = configuration;
    }

    public void execute(RuleSet ruleSet, RuleSelection ruleSelection) throws RuleException {
        ActivatedConceptsVisitor activatedConceptsVisitor = new ActivatedConceptsVisitor();
        new RuleSetExecutor<Boolean>(activatedConceptsVisitor, this.configuration).execute(ruleSet, ruleSelection, Collections.emptySet());
        Set<String> userActivatedConcepts = activatedConceptsVisitor.getActivatedConcepts();
        log.debug("Executing with activated concepts: {}", userActivatedConcepts);
        this.execute(ruleSet, ruleSelection, userActivatedConcepts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(RuleSet ruleSet, RuleSelection ruleSelection, Set<String> activatedConcepts) throws RuleException {
        this.ruleVisitor.beforeRules();
        try {
            for (String conceptPattern : ruleSelection.getConceptIds()) {
                this.applyConcepts(ruleSet, conceptPattern, null, activatedConcepts);
            }
            for (String groupPattern : ruleSelection.getGroupIds()) {
                this.executeGroups(ruleSet, groupPattern, ruleSelection.getExcludeConstraintIds(), null, activatedConcepts);
            }
            for (String constraintPattern : ruleSelection.getConstraintIds()) {
                this.validateConstraints(ruleSet, constraintPattern, ruleSelection.getExcludeConstraintIds(), null, activatedConcepts);
            }
        }
        finally {
            this.ruleVisitor.afterRules();
        }
        if (this.executedConcepts.isEmpty() && this.executedConstraints.isEmpty()) {
            log.warn("No concepts or constraints were executed.");
        }
    }

    private void executeGroup(RuleSet ruleSet, Group group, Set<String> excludedConstraintIds, Severity overriddenSeverity, Set<String> activatedConcepts) throws RuleException {
        if (!this.executedGroups.contains(group)) {
            Severity groupSeverity = this.getEffectiveSeverity(overriddenSeverity, group.getSeverity());
            this.ruleVisitor.beforeGroup(group, groupSeverity);
            for (Map.Entry<String, Severity> conceptEntry : group.getConcepts().entrySet()) {
                this.applyConcepts(ruleSet, conceptEntry.getKey(), this.getEffectiveSeverity(conceptEntry.getValue(), groupSeverity), activatedConcepts);
            }
            for (Map.Entry<String, Severity> groupEntry : group.getGroups().entrySet()) {
                Severity effectiveSeverity = this.getEffectiveSeverity(groupEntry.getValue(), groupSeverity);
                this.executeGroups(ruleSet, groupEntry.getKey(), excludedConstraintIds, effectiveSeverity, activatedConcepts);
            }
            Map<String, Severity> constraints = group.getConstraints();
            for (Map.Entry<String, Severity> constraintEntry : constraints.entrySet()) {
                Severity effectiveSeverity = this.getEffectiveSeverity(constraintEntry.getValue(), groupSeverity);
                this.validateConstraints(ruleSet, constraintEntry.getKey(), excludedConstraintIds, effectiveSeverity, activatedConcepts);
            }
            this.ruleVisitor.afterGroup(group);
            this.executedGroups.add(group);
        }
    }

    private void applyConcepts(RuleSet ruleSet, String conceptPattern, Severity overriddenSeverity, Set<String> activatedConcepts) throws RuleException {
        List matchingConcepts = ruleSet.getConceptBucket().match(conceptPattern);
        if (matchingConcepts.isEmpty()) {
            LOGGER.warn("Could not find concepts matching to '{}'.", (Object)conceptPattern);
        } else {
            for (Concept matchingConcept : matchingConcepts) {
                this.applyConcept(ruleSet, matchingConcept, overriddenSeverity, activatedConcepts, new LinkedHashSet<Concept>());
            }
        }
    }

    private void executeGroups(RuleSet ruleSet, String groupPattern, Set<String> excludedConstraintIds, Severity overridingSeverity, Set<String> activatedConcepts) throws RuleException {
        List matchingGroups = ruleSet.getGroupsBucket().match(groupPattern);
        if (matchingGroups.isEmpty()) {
            LOGGER.warn("Could not find groups matching to '{}'.", (Object)groupPattern);
        } else {
            for (Group matchingGroup : matchingGroups) {
                this.executeGroup(ruleSet, matchingGroup, excludedConstraintIds, overridingSeverity, activatedConcepts);
            }
        }
    }

    private void validateConstraints(RuleSet ruleSet, String constraintPattern, Set<String> excludedConstraintIds, Severity overriddenSeverity, Set<String> activatedConcepts) throws RuleException {
        List matchingConstraints = ruleSet.getConstraintBucket().match(constraintPattern);
        if (matchingConstraints.isEmpty()) {
            LOGGER.warn("Could not find constraints matching to '{}'.", (Object)constraintPattern);
        } else {
            for (Constraint matchingConstraint : matchingConstraints) {
                String constraintId = matchingConstraint.getId();
                if (excludedConstraintIds.contains(constraintId)) {
                    log.info("Skipping excluded constraint '{}'.", (Object)constraintId);
                    continue;
                }
                this.validateConstraint(ruleSet, matchingConstraint, overriddenSeverity, activatedConcepts);
            }
        }
    }

    private Severity getEffectiveSeverity(Severity ... severities) {
        for (Severity severity : severities) {
            if (severity == null) continue;
            return severity;
        }
        return null;
    }

    private void validateConstraint(RuleSet ruleSet, Constraint constraint, Severity overriddenSeverity, Set<String> activatedConcepts) throws RuleException {
        if (!this.executedConstraints.contains(constraint)) {
            Severity effectiveSeverity = this.getEffectiveSeverity(overriddenSeverity, constraint.getSeverity());
            Map<Map.Entry<Concept, Boolean>, R> requiredConceptResults = this.applyRequiredConcepts(ruleSet, constraint, activatedConcepts, new LinkedHashSet<Concept>());
            if (this.requiredConceptsAreSuccessful(requiredConceptResults)) {
                this.checkDeprecation(constraint);
                this.ruleVisitor.visitConstraint(constraint, effectiveSeverity, requiredConceptResults);
            } else {
                this.ruleVisitor.skipConstraint(constraint, effectiveSeverity, requiredConceptResults);
            }
            this.executedConstraints.add(constraint);
        }
    }

    private R applyConcept(RuleSet ruleSet, Concept concept, Severity overriddenSeverity, Set<String> activatedConcepts, Set<Concept> executionStack) throws RuleException {
        R result = this.executedConcepts.get(concept);
        if (result == null) {
            executionStack.add(concept);
            Severity effectiveSeverity = this.getEffectiveSeverity(overriddenSeverity, concept.getSeverity());
            Map<Map.Entry<Concept, Boolean>, R> requiredConceptResults = this.applyAllRequiredConcepts(ruleSet, concept, activatedConcepts, executionStack);
            if (this.requiredConceptsAreSuccessful(requiredConceptResults)) {
                Map<Concept, R> providedConceptResults = this.applyProvidingConcepts(ruleSet, concept, overriddenSeverity, activatedConcepts, executionStack);
                this.checkDeprecation(concept);
                result = this.ruleVisitor.visitConcept(concept, effectiveSeverity, requiredConceptResults, providedConceptResults);
            } else {
                this.ruleVisitor.skipConcept(concept, effectiveSeverity, requiredConceptResults);
            }
            executionStack.remove(concept);
            this.executedConcepts.put(concept, result);
        }
        return result;
    }

    private boolean requiredConceptsAreSuccessful(Map<Map.Entry<Concept, Boolean>, R> requiredConceptResults) {
        return requiredConceptResults.entrySet().stream().allMatch(entry -> {
            Boolean isOptional = (Boolean)((Map.Entry)entry.getKey()).getValue();
            return (isOptional != null ? isOptional != false : this.configuration.requiredConceptsAreOptionalByDefault()) || this.ruleVisitor.isSuccess(entry.getValue());
        });
    }

    private Map<Concept, R> applyProvidingConcepts(RuleSet ruleSet, Concept concept, Severity overriddenSeverity, Set<String> activatedConcepts, Set<Concept> stack) throws RuleException {
        LinkedHashMap<Concept, R> results = new LinkedHashMap<Concept, R>();
        Severity providedSeverity = concept.getSeverity();
        for (Concept.ProvidedConcept providedConcept : ruleSet.getProvidedConcepts().getOrDefault(concept.getId(), Collections.emptySet())) {
            Concept providingConcept = (Concept)ruleSet.getConceptBucket().getById(providedConcept.getProvidingConceptId());
            if (!RuleSetExecutor.isProvidingConceptActivated(providingConcept, providedConcept.getActivation(), activatedConcepts)) continue;
            Severity providingSeverity = providingConcept.getSeverity();
            Severity effectiveSeverity = this.getEffectiveSeverity(overriddenSeverity, providedSeverity.getLevel() < providingSeverity.getLevel() ? providedSeverity : providingSeverity);
            R result = this.applyConcept(ruleSet, providingConcept, effectiveSeverity, activatedConcepts, stack);
            results.put(providingConcept, result);
        }
        return results;
    }

    private static boolean isProvidingConceptActivated(Concept providingConcept, Concept.Activation activation, Set<String> activatedConcepts) throws RuleException {
        switch (activation) {
            case IF_AVAILABLE: {
                return true;
            }
            case IF_REQUIRED: {
                return activatedConcepts.contains(providingConcept.getId());
            }
        }
        throw new RuleException("Unknown activation strategy " + String.valueOf((Object)activation) + " for providing concept + " + providingConcept.getId());
    }

    private Map<Map.Entry<Concept, Boolean>, R> applyAllRequiredConcepts(RuleSet ruleSet, Concept concept, Set<String> activatedConcepts, Set<Concept> stack) throws RuleException {
        HashMap<Map.Entry<Concept, Boolean>, R> requiredConcepts = new HashMap<Map.Entry<Concept, Boolean>, R>();
        Set<String> conceptIds = ruleSet.getConceptBucket().getIds();
        for (String providedConceptId : ruleSet.getProvidingConceptIds().getOrDefault(concept.getId(), Collections.emptySet())) {
            if (conceptIds.contains(providedConceptId)) {
                Concept providedConcept = (Concept)ruleSet.getConceptBucket().getById(providedConceptId);
                requiredConcepts.putAll(this.applyAllRequiredConcepts(ruleSet, providedConcept, activatedConcepts, stack));
                continue;
            }
            log.warn("Cannot resolve provided concept '{}' (provided by concept '{}').", (Object)providedConceptId, (Object)concept.getId());
        }
        requiredConcepts.putAll(this.applyRequiredConcepts(ruleSet, concept, activatedConcepts, stack));
        return requiredConcepts;
    }

    private Map<Map.Entry<Concept, Boolean>, R> applyRequiredConcepts(RuleSet ruleSet, ExecutableRule<?> rule, Set<String> activatedConcepts, Set<Concept> stack) throws RuleException {
        HashMap<AbstractMap.SimpleEntry<Concept, Boolean>, R> requiredConcepts = new HashMap<AbstractMap.SimpleEntry<Concept, Boolean>, R>();
        for (Map.Entry<String, Boolean> entry : rule.getRequiresConcepts().entrySet()) {
            for (Concept requiredConcept : ruleSet.getConceptBucket().match(entry.getKey())) {
                if (stack.contains(requiredConcept)) continue;
                R conceptResult = this.applyConcept(ruleSet, requiredConcept, null, activatedConcepts, stack);
                requiredConcepts.put(new AbstractMap.SimpleEntry<Concept, Boolean>(requiredConcept, entry.getValue()), conceptResult);
            }
        }
        return requiredConcepts;
    }

    private void checkDeprecation(ExecutableRule<?> executableRule) {
        String deprecation = executableRule.getDeprecation();
        if (deprecation != null) {
            log.warn("Rule '{}' is deprecated: {} ({})", new Object[]{executableRule.getId(), executableRule.getDeprecation(), executableRule.getSource().getId()});
        }
    }

    private static class ActivatedConceptsVisitor
    extends AbstractRuleVisitor<Boolean> {
        private final Set<String> activatedConcepts = new HashSet<String>();

        private ActivatedConceptsVisitor() {
        }

        @Override
        public Boolean visitConcept(Concept concept, Severity effectiveSeverity, Map<Map.Entry<Concept, Boolean>, Boolean> requiredConceptResults, Map<Concept, Boolean> providingConceptResults) {
            this.activatedConcepts.add(concept.getId());
            return true;
        }

        @Override
        public Boolean visitConstraint(Constraint constraint, Severity effectiveSeverity, Map<Map.Entry<Concept, Boolean>, Boolean> requiredConceptResults) {
            return true;
        }

        @Generated
        public Set<String> getActivatedConcepts() {
            return this.activatedConcepts;
        }

        @Generated
        public String toString() {
            return "RuleSetExecutor.ActivatedConceptsVisitor(activatedConcepts=" + String.valueOf(this.getActivatedConcepts()) + ")";
        }
    }
}

