/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.model;

import com.buschmais.jqassistant.core.rule.api.model.RuleException;

public class Parameter {
    private String name;
    private Type type;
    private Object defaultValue;

    public Parameter(String name, Type type, Object defaultValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public static enum Type {
        CHAR{

            @Override
            protected Object parseString(String value) {
                return Character.valueOf(value.charAt(0));
            }
        }
        ,
        BYTE{

            @Override
            protected Object parseString(String value) {
                return Byte.valueOf(value);
            }
        }
        ,
        SHORT{

            @Override
            public Object parseString(String value) {
                return Short.valueOf(value);
            }
        }
        ,
        INT{

            @Override
            public Object parseString(String value) {
                return Integer.valueOf(value);
            }
        }
        ,
        LONG{

            @Override
            public Object parseString(String value) {
                return Long.valueOf(value);
            }
        }
        ,
        FLOAT{

            @Override
            public Object parseString(String value) {
                return Float.valueOf(value);
            }
        }
        ,
        DOUBLE{

            @Override
            public Object parseString(String value) {
                return Double.valueOf(value);
            }
        }
        ,
        BOOLEAN{

            @Override
            public Object parseString(String value) {
                return Boolean.valueOf(value);
            }
        }
        ,
        STRING{

            @Override
            public Object parseString(String value) {
                return value;
            }
        };


        protected abstract Object parseString(String var1);

        public Object parse(String value) throws RuleException {
            try {
                return value != null ? this.parseString(value) : null;
            }
            catch (NumberFormatException e) {
                throw new RuleException("Cannot parse value " + value + " for type " + this.name());
            }
        }
    }
}

