/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.model;

import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import java.util.EnumSet;
import java.util.Optional;
import lombok.Generated;

public enum Severity {
    BLOCKER("blocker", 0),
    CRITICAL("critical", 1),
    MAJOR("major", 2),
    MINOR("minor", 3),
    INFO("info", 4);

    private final String value;
    private final Integer level;

    public String getInfo(Severity fromSeverity) {
        StringBuilder result = new StringBuilder(this.name());
        if (!this.equals((Object)fromSeverity)) {
            result.append(" (from ").append((Object)fromSeverity).append(")");
        }
        return result.toString();
    }

    public boolean exceeds(Threshold threshold) {
        return threshold.getThreshold().map(thresholdSeverity -> this.level <= thresholdSeverity.level).orElse(false);
    }

    public static Severity fromValue(String value) throws RuleException {
        if (value == null) {
            return null;
        }
        for (Severity severity : EnumSet.allOf(Severity.class)) {
            if (!severity.value.equals(value.toLowerCase())) continue;
            return severity;
        }
        throw new RuleException("Unknown severity '" + value + "'");
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Integer getLevel() {
        return this.level;
    }

    @Generated
    private Severity(String value, Integer level) {
        this.value = value;
        this.level = level;
    }

    public static class Threshold {
        public static final String NEVER = "never";
        private final Optional<Severity> threshold;

        public static Threshold from(Severity value) {
            return new Threshold(Optional.of(value));
        }

        public static Threshold from(String value) throws RuleException {
            String trimmedValue = value.trim();
            if (NEVER.equalsIgnoreCase(trimmedValue)) {
                return new Threshold(Optional.empty());
            }
            return new Threshold(Optional.of(Severity.fromValue(trimmedValue)));
        }

        public String toString() {
            return this.threshold.map(severity -> severity.name()).orElse(NEVER);
        }

        @Generated
        public static ThresholdBuilder builder() {
            return new ThresholdBuilder();
        }

        @Generated
        public Optional<Severity> getThreshold() {
            return this.threshold;
        }

        @Generated
        private Threshold(Optional<Severity> threshold) {
            this.threshold = threshold;
        }

        @Generated
        public static class ThresholdBuilder {
            @Generated
            private Optional<Severity> threshold;

            @Generated
            ThresholdBuilder() {
            }

            @Generated
            public ThresholdBuilder threshold(Optional<Severity> threshold) {
                this.threshold = threshold;
                return this;
            }

            @Generated
            public Threshold build() {
                return new Threshold(this.threshold);
            }

            @Generated
            public String toString() {
                return "Severity.Threshold.ThresholdBuilder(threshold=" + String.valueOf(this.threshold) + ")";
            }
        }
    }
}

