/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.impl.reader;

import com.buschmais.jqassistant.core.rule.api.model.AbstractExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.CypherExecutable;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.Parameter;
import com.buschmais.jqassistant.core.rule.api.model.Report;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSetBuilder;
import com.buschmais.jqassistant.core.rule.api.model.ScriptExecutable;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.api.model.Verification;
import com.buschmais.jqassistant.core.rule.api.reader.AggregationVerification;
import com.buschmais.jqassistant.core.rule.api.reader.RowCountVerification;
import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import com.buschmais.jqassistant.core.rule.impl.SourceExecutable;
import com.buschmais.jqassistant.core.rule.impl.reader.AbstractRuleParserPlugin;
import com.buschmais.jqassistant.core.rule.impl.reader.IndentHelper;
import com.buschmais.jqassistant.core.rule.impl.reader.JsonSchemaValidator;
import com.buschmais.jqassistant.core.rule.impl.reader.ValidationResult;
import com.google.common.base.CaseFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.YamlUnicodeReader;

public class YamlRuleParserPlugin
extends AbstractRuleParserPlugin {
    private JsonSchemaValidator validator;
    private static final String YAML_EXTENSION_LONG = ".yaml";
    private static final String YAML_EXTENSION_SHORT = ".yml";

    @Override
    public void initialize() throws RuleException {
        this.validator = new JsonSchemaValidator();
    }

    @Override
    public boolean accepts(RuleSource ruleSource) throws RuleException {
        try {
            String fileName = ruleSource.getURL().toExternalForm().toLowerCase();
            return fileName.endsWith(YAML_EXTENSION_LONG) || fileName.endsWith(YAML_EXTENSION_SHORT);
        }
        catch (IOException e) {
            throw new RuleException("Unable to get the URL of the rule source.", e);
        }
    }

    @Override
    protected void doParse(RuleSource ruleSource, RuleSetBuilder ruleSetBuilder) throws RuleException {
        RuleContext context = new RuleContext(ruleSource, ruleSetBuilder);
        try {
            ValidationResult validationResult = this.validator.validate(ruleSource);
            if (!validationResult.isSourceWasEmpty() && validationResult.hasErrors()) {
                throw new RuleException(String.valueOf(ruleSource) + " has validation errors: " + validationResult.getValidationMessages().stream().map(Object::toString).collect(Collectors.joining("; ")));
            }
            try (InputStream inputStream = ruleSource.getInputStream();
                 YamlUnicodeReader reader = new YamlUnicodeReader(inputStream);){
                LoadSettings settings = LoadSettings.builder().build();
                Load load = new Load(settings);
                Iterable objects = load.loadAllFromReader((Reader)reader);
                for (Object object : objects) {
                    if (null == object) continue;
                    if (Map.class.isAssignableFrom(object.getClass())) {
                        this.processDocument((Map)object, context);
                        continue;
                    }
                    throw new RuleException("Cannot process rules from '" + ruleSource.getId() + "'.");
                }
            }
        }
        catch (IOException e) {
            String message = String.format("Cannot read rules from '%s'.", ruleSource.getId());
            throw new RuleException(message, e);
        }
        catch (ClassCastException e) {
            String message = String.format("Cannot process rules from '%s' because of an invalid YAML datastructure", ruleSource.getId());
            throw new RuleException(message);
        }
    }

    private void processDocument(Map<String, Object> documentMap, RuleContext context) throws RuleException {
        AbstractExecutableRule.Builder builder;
        List executableRules;
        boolean containsConcepts = documentMap.containsKey("concepts");
        boolean containsConstraints = documentMap.containsKey("constraints");
        boolean containsGroups = documentMap.containsKey("groups");
        if (containsConcepts) {
            executableRules = Optional.ofNullable(documentMap.get("concepts")).orElse(Collections.emptyList());
            for (Map executableRule : executableRules) {
                builder = Concept.builder();
                String conceptId = this.processExecutableRule(executableRule, context, builder, this::getDefaultConceptSeverity);
                Set<Concept.ProvidedConcept> providedConcepts = this.extractProvidedConcepts(conceptId, executableRule);
                ((Concept.ConceptBuilder)builder).providedConcepts(providedConcepts);
                context.getBuilder().addConcept((Concept)builder.build());
            }
        }
        if (containsConstraints) {
            executableRules = Optional.ofNullable(documentMap.get("constraints")).orElse(Collections.emptyList());
            for (Map executableRule : executableRules) {
                builder = Constraint.builder();
                this.processExecutableRule(executableRule, context, builder, this::getDefaultConstraintSeverity);
                context.getBuilder().addConstraint((Constraint)builder.build());
            }
        }
        if (containsGroups) {
            List groupRules = Optional.ofNullable(documentMap.get("groups")).orElse(Collections.emptyList());
            for (Map groupRule : groupRules) {
                this.processGroup(groupRule, context);
            }
        }
    }

    private void processGroup(Map<String, Object> map, RuleContext context) throws RuleException {
        RuleSeverityAssociation reference;
        String id = (String)map.get("id");
        List concepts = (List)map.computeIfAbsent("includedConcepts", key -> Collections.emptyList());
        HashMap<String, Set<Concept.ProvidedConcept>> providedConcepts = new HashMap<String, Set<Concept.ProvidedConcept>>();
        List constraints = (List)map.computeIfAbsent("includedConstraints", key -> Collections.emptyList());
        List groups = (List)map.computeIfAbsent("includedGroups", key -> Collections.emptyList());
        SeverityMap includedGroups = new SeverityMap();
        SeverityMap includedConstraints = new SeverityMap();
        SeverityMap includedConcepts = new SeverityMap();
        for (Map refSpec : concepts) {
            reference = this.extractRuleReferencesFrom(refSpec);
            includedConcepts.add(reference);
            for (Concept.ProvidedConcept providedConcept : this.extractProvidedConcepts(reference.getRuleName(), refSpec)) {
                providedConcepts.computeIfAbsent(providedConcept.getProvidedConceptId(), key -> new LinkedHashSet()).add(providedConcept);
            }
        }
        for (Map refSpec : constraints) {
            RuleSeverityAssociation references = this.extractRuleReferencesFrom(refSpec);
            includedConstraints.add(references);
        }
        for (Map refSpec : groups) {
            reference = this.extractRuleReferencesFrom(refSpec);
            includedGroups.add(reference);
        }
        String severityVal = (String)map.get("severity");
        Severity severity = this.getSeverity(severityVal, this::getDefaultGroupSeverity);
        Group group = (Group)((Group.GroupBuilder)((Group.GroupBuilder)((Group.GroupBuilder)Group.builder().id(id)).severity(severity)).ruleSource(context.getSource())).concepts(includedConcepts).constraints(includedConstraints).providedConcepts(providedConcepts).groups(includedGroups).build();
        context.getBuilder().addGroup(group);
    }

    private RuleSeverityAssociation extractRuleReferencesFrom(Map<String, Object> refSpec) throws RuleException {
        String refId = (String)refSpec.get("refId");
        String severityVal = (String)refSpec.get("severity");
        Severity severity = this.getSeverity(severityVal, this::getDefaultIncludeSeverity);
        return new RuleSeverityAssociation(refId, severity);
    }

    private <T extends AbstractExecutableRule, B extends AbstractExecutableRule.Builder<B, T>> String processExecutableRule(Map<String, Object> map, RuleContext context, B builder, Supplier<Severity> defaultSeveritySupplier) throws RuleException {
        String id = (String)map.get("id");
        String description = IndentHelper.removeIndent((String)map.get("description"));
        String source = (String)map.get("source");
        String language = (String)map.get("language");
        SourceExecutable executable = "cypher".equals(language) || null == language ? new CypherExecutable(source) : new ScriptExecutable(language, source);
        Map<String, Boolean> required = this.extractRequiredConcepts(map);
        Map<String, Parameter> parameters = this.extractParameters(map);
        Verification verification = this.extractVerification(map);
        Report report = this.extractReportConfiguration(map);
        Severity severity = this.getSeverity((String)map.get("severity"), defaultSeveritySupplier);
        ((AbstractExecutableRule.Builder)((AbstractExecutableRule.Builder)((AbstractExecutableRule.Builder)((AbstractExecutableRule.Builder)((AbstractExecutableRule.Builder)((AbstractExecutableRule.Builder)((AbstractExecutableRule.Builder)((AbstractExecutableRule.Builder)builder.id(id)).description(description)).severity(severity)).executable(executable)).requiresConcepts(required)).parameters(parameters)).verification(verification)).report(report)).ruleSource(context.getSource());
        return id;
    }

    protected Report extractReportConfiguration(Map<String, Object> map) {
        Report.ReportBuilder reportBuilder = Report.builder();
        Optional<Map> reportBlockOpt = Optional.ofNullable((Map)map.get("report"));
        if (reportBlockOpt.isPresent()) {
            Map reportBlock = reportBlockOpt.get();
            if (reportBlock.containsKey("type")) {
                String reportType = (String)reportBlock.get("type");
                reportBuilder.selectedTypes(Report.selectTypes(reportType));
            }
            if (reportBlock.containsKey("primaryColumn")) {
                String primaryColumn = (String)reportBlock.get("primaryColumn");
                reportBuilder.primaryColumn(primaryColumn);
            }
            if (reportBlock.containsKey("properties")) {
                Map propertiesMap = (Map)reportBlock.get("properties");
                Properties reportProperties = new Properties();
                Consumer<String> propertyConsumer = key -> {
                    Object val = propertiesMap.get(key);
                    reportProperties.put(key, val);
                };
                propertiesMap.keySet().forEach(propertyConsumer);
                reportBuilder.properties(reportProperties);
            }
        }
        return reportBuilder.build();
    }

    private Verification extractVerification(Map<String, Object> map) {
        Verification verification = null;
        if (map.containsKey("verify")) {
            Map verify = (Map)map.get("verify");
            boolean hasAggregation = verify.containsKey("aggregation");
            if (hasAggregation) {
                Map config = (Map)verify.get("aggregation");
                String columnName = (String)config.get("column");
                Integer min = (Integer)config.get("min");
                Integer max = (Integer)config.get("max");
                verification = AggregationVerification.builder().column(columnName).min(min).max(max).build();
            } else {
                Map config = (Map)verify.get("rowCount");
                Integer min = (Integer)config.get("min");
                Integer max = (Integer)config.get("max");
                verification = RowCountVerification.builder().min(min).max(max).build();
            }
        }
        return verification;
    }

    private Map<String, Boolean> extractRequiredConcepts(Map<String, Object> map) {
        HashMap<String, Boolean> requiredConcepts = new HashMap<String, Boolean>();
        boolean hasRequiresSection = map.containsKey("requiresConcepts");
        if (hasRequiresSection) {
            List list = (List)map.get("requiresConcepts");
            for (Map required : list) {
                String refIdVal = (String)required.get("refId");
                Boolean optionalVal = (Boolean)required.get("optional");
                Boolean aBoolean = Optional.ofNullable(optionalVal).orElse(Boolean.FALSE);
                requiredConcepts.put(refIdVal, aBoolean);
            }
        }
        return Collections.unmodifiableMap(requiredConcepts);
    }

    private Set<Concept.ProvidedConcept> extractProvidedConcepts(String providingConceptId, Map<String, Object> map) {
        LinkedHashSet<Concept.ProvidedConcept> providedConcepts = new LinkedHashSet<Concept.ProvidedConcept>();
        boolean hasProvidesSection = map.containsKey("providesConcepts");
        if (hasProvidesSection) {
            List list = (List)map.get("providesConcepts");
            for (Map required : list) {
                String refIdVal = (String)required.get("refId");
                Concept.Activation activationVal = Concept.Activation.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, required.getOrDefault("activation", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, Concept.Activation.IF_AVAILABLE.name()))));
                providedConcepts.add(Concept.ProvidedConcept.builder().providingConceptId(providingConceptId).providedConceptId(refIdVal).activation(activationVal).build());
            }
        }
        return Collections.unmodifiableSet(providedConcepts);
    }

    private Map<String, Parameter> extractParameters(Map<String, Object> map) {
        Map<String, Parameter> parameters = Collections.emptyMap();
        boolean hasParameters = map.containsKey("requiresParameters");
        if (hasParameters) {
            List list = (List)map.computeIfAbsent("requiresParameters", key -> Collections.emptyList());
            parameters = new HashMap<String, Parameter>();
            for (Map parameterSpec : list) {
                String nameVal = (String)parameterSpec.get("name");
                String defaultVal = (String)parameterSpec.get("defaultValue");
                String typeVal = (String)parameterSpec.get("type");
                Parameter.Type type = YamlRuleParserPlugin.toType(typeVal);
                Parameter parameter = new Parameter(nameVal, type, defaultVal);
                parameters.put(nameVal, parameter);
            }
        }
        return parameters;
    }

    private static Parameter.Type toType(String value) {
        return Parameter.Type.valueOf(value.toUpperCase());
    }

    private static class RuleContext {
        private final RuleSource source;
        private final RuleSetBuilder builder;

        @Generated
        public RuleSource getSource() {
            return this.source;
        }

        @Generated
        public RuleSetBuilder getBuilder() {
            return this.builder;
        }

        @Generated
        public RuleContext(RuleSource source, RuleSetBuilder builder) {
            this.source = source;
            this.builder = builder;
        }
    }

    static class SeverityMap
    extends HashMap<String, Severity> {
        SeverityMap() {
        }

        public void add(RuleSeverityAssociation reference) {
            this.put(reference.getRuleName(), reference.getSeverity());
        }
    }

    static class RuleSeverityAssociation {
        private final String ruleName;
        private final Severity severity;

        @Generated
        public String getRuleName() {
            return this.ruleName;
        }

        @Generated
        public Severity getSeverity() {
            return this.severity;
        }

        @Generated
        public RuleSeverityAssociation(String ruleName, Severity severity) {
            this.ruleName = ruleName;
            this.severity = severity;
        }
    }
}

